/*
 * Decompiled with CFR 0.152.
 */
package com.yishuifengxiao.common.tool.utils;

import com.yishuifengxiao.common.tool.exception.ValidateException;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertNoUtil {
    private static final Logger log = LoggerFactory.getLogger(CertNoUtil.class);
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final int LENGTH_LONG_IDCARD = 18;

    public static synchronized boolean isValid(String idcard) {
        try {
            CertNoUtil.getBirthday(idcard);
        }
        catch (ValidateException e) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        String idcard18Code = idcard.substring(17, 18);
        if (!CertNoUtil.isDigital(idcard17)) {
            return false;
        }
        char[] c = idcard17.toCharArray();
        int[] bit = CertNoUtil.converCharToInt(c);
        int sum17 = CertNoUtil.getPowerSum(bit);
        String checkCode = CertNoUtil.getCheckCodeBySum(sum17);
        if (null == checkCode) {
            return false;
        }
        return idcard18Code.equalsIgnoreCase(checkCode);
    }

    public static synchronized LocalDate getBirthday(String str) throws ValidateException {
        if (StringUtils.length((CharSequence)str) != 18) {
            throw new ValidateException("\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        LocalDate localDate = null;
        try {
            String year = StringUtils.substring((String)str, (int)6, (int)10);
            String month = StringUtils.substring((String)str, (int)10, (int)12);
            String day = StringUtils.substring((String)str, (int)12, (int)14);
            localDate = LocalDate.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
        catch (Exception e) {
            log.info("\u4ece\u8eab\u4efd\u8bc1\u53f7{}\u4e2d\u63d0\u53d6\u51fa\u751f\u65e5\u671f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u51fa\u73b0\u5f02\u5e38\u7684\u539f\u56e0\u4e3a {}", (Object)str, (Object)e.getMessage());
            throw new ValidateException("\u8eab\u4efd\u8bc1\u53f7\u51fa\u751f\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return localDate;
    }

    private static boolean isDigital(String str) {
        return str == null || "".equals(str) ? false : str.matches("^[0-9]*$");
    }

    private static int getPowerSum(int[] bit) {
        int sum = 0;
        if (POWER.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < POWER.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * POWER[j];
            }
        }
        return sum;
    }

    private static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
                break;
            }
        }
        return checkCode;
    }

    private static int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }

    public static void main(String[] args) throws ValidateException {
        System.out.println(CertNoUtil.isValid("110101199003078275"));
        System.out.println(CertNoUtil.isValid("110101199003075453"));
        System.out.println(CertNoUtil.isValid("11010119900307301X"));
        System.out.println(CertNoUtil.isValid("110101199003073011"));
        System.out.println(CertNoUtil.isValid("42010319900307291X"));
        System.out.println(CertNoUtil.getBirthday("42010319900307291X"));
    }
}

