/*
 * Decompiled with CFR 0.152.
 */
package com.yishuifengxiao.common.tool.http;

import com.yishuifengxiao.common.tool.collections.EmptyUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class CookieUtil {
    public static final int COOKIE_MAX_AGE = 604800;
    public static final int COOKIE_HALF_HOUR = 1800;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public static CookieUtil getInstance(HttpServletRequest request, HttpServletResponse response) {
        return new CookieUtil(request, response);
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null || cookies.length < 1) {
            return null;
        }
        Cookie cookie = null;
        for (Cookie c : cookies) {
            if (!name.equals(c.getName())) continue;
            cookie = c;
            break;
        }
        return cookie;
    }

    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public void removeCookie(String name) {
        if (null == name) {
            return;
        }
        Cookie cookie = this.getCookie(name);
        if (null != cookie) {
            cookie.setPath("/");
            cookie.setValue("");
            cookie.setMaxAge(0);
            this.response.addCookie(cookie);
        }
    }

    public void setCookie(String name, String value, int maxValue) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        if (null == value) {
            value = "";
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxValue != 0) {
            cookie.setMaxAge(maxValue);
        } else {
            cookie.setMaxAge(1800);
        }
        this.response.addCookie(cookie);
        try {
            this.response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, 1800);
    }

    public Map<String, Cookie> getCookieMap() {
        Cookie[] cookies = this.request.getCookies();
        if (EmptyUtil.notEmpty(cookies)) {
            HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>(cookies.length);
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return null;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public CookieUtil(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public CookieUtil() {
    }
}

