/*
 * Decompiled with CFR 0.152.
 */
package com.yishuifengxiao.common.tool.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ApiModel(value="\u901a\u7528\u5206\u9875\u5b9e\u4f53\u7c7b", description="\u7528\u4e8e\u6240\u6709\u63a5\u53e3\u7684\u901a\u7528\u8fd4\u56de\u6570\u636e")
public class Page<T>
implements Serializable {
    public static final int DEFAULT_PAGE_NUM = 0;
    public static final int MIN_PAGE_NUM = 1;
    public static final int FIRST_ELEMENT_INDEX = 0;
    private static final long serialVersionUID = 1466782682580092020L;
    @ApiModelProperty(value="\u5206\u9875\u5927\u5c0f")
    private Long pageSize;
    @ApiModelProperty(value="\u5f53\u524d\u9875\u9875\u7801(\u4ece1\u5f00\u59cb)")
    private Long pageNum;
    @ApiModelProperty(value="\u5f53\u524d\u5206\u9875\u91cc\u7684\u6570\u636e")
    private List<T> data;
    @ApiModelProperty(value="\u603b\u7684\u5206\u9875\u6570")
    private Long pages;
    @ApiModelProperty(value="\u603b\u7684\u8bb0\u5f55\u6570")
    private Long total;

    public static int reduce(Integer pageSize) {
        if (pageSize == null || pageSize < 1) {
            return 0;
        }
        return pageSize > 0 ? pageSize - 1 : pageSize;
    }

    public static <T> Page<T> of(List<T> data) {
        data = data == null ? new ArrayList() : data;
        return new Page((long)data.size() + 0L, 1L, data, 1L, (long)data.size() + 0L);
    }

    public static <T> Page<T> of(Long pageSize, Long pageNum, List<T> data, Long totalPage, Long total) {
        return new Page<T>(pageSize, pageNum, data, totalPage, total);
    }

    public static <T> Page<T> of(List<T> data, Long pageSize, Long pageNum, Long total) {
        long totalPage = total % pageSize == 0L ? total / pageSize : total / pageSize + 1L;
        return new Page<T>(pageSize, pageNum, data, totalPage, total);
    }

    public static <T, U> Page<T> of(Page<U> source, List<T> data) {
        return new Page<T>(source.getPageSize(), source.getPageNum(), data, source.getPages(), source.getTotal());
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public Page<T> setPageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Long getPageNum() {
        return this.pageNum;
    }

    public Page<T> setPageNum(Long pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    public Long getTotal() {
        return this.total;
    }

    public Page<T> setTotal(Long total) {
        this.total = total;
        return this;
    }

    public List<T> getData() {
        return this.data;
    }

    public Page<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public Long getPages() {
        return this.pages;
    }

    public void setPages(Long pages) {
        this.pages = pages;
    }

    public Page(Long pageSize, Long pageNum, List<T> data, Long pages, Long total) {
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.data = data;
        this.pages = pages;
        this.total = total;
    }

    public Page() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Page [pageSize=");
        builder.append(this.pageSize);
        builder.append(", pageNum=");
        builder.append(this.pageNum);
        builder.append(", data=");
        builder.append(this.data);
        builder.append(", pages=");
        builder.append(this.pages);
        builder.append(", total=");
        builder.append(this.total);
        builder.append("]");
        return builder.toString();
    }
}

