/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.serializer.impl;

import com.xxl.tool.serializer.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JavaSerializer
extends Serializer {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> byte[] serialize(T obj) {
        if (obj == null) {
            throw new RuntimeException("Cannot serialize null object");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize object: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(byte[] bytes) {
        if (bytes == null) {
            throw new RuntimeException("Cannot deserialize null byte array");
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize object: " + e.getMessage(), e);
        }
    }
}

