/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.impl.AnsiSqlDialect;
import com.xiaoleilu.hutool.db.dialect.impl.H2Dialect;
import com.xiaoleilu.hutool.db.dialect.impl.MysqlDialect;
import com.xiaoleilu.hutool.db.dialect.impl.OracleDialect;
import com.xiaoleilu.hutool.db.dialect.impl.PostgresqlDialect;
import com.xiaoleilu.hutool.db.dialect.impl.SqlServer2012Dialect;
import com.xiaoleilu.hutool.db.dialect.impl.Sqlite3Dialect;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import javax.sql.DataSource;

public class DialectFactory {
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    public static final String DRIVER_SQLLITE3 = "org.sqlite.JDBC";
    public static final String DRIVER_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String DRIVER_HIVE = "org.apache.hadoop.hive.jdbc.HiveDriver";
    public static final String DRIVER_HIVE2 = "org.apache.hive.jdbc.HiveDriver";
    public static final String DRIVER_H2 = "org.h2.Driver";
    public static final String DRIVER_DERBY = "org.apache.derby.jdbc.ClientDriver";
    public static final String DRIVER_DERBY_EMBEDDED = "org.apache.derby.jdbc.EmbeddedDriver";

    private DialectFactory() {
    }

    public static Dialect newDialect(String driverName) {
        if (StrUtil.isNotBlank(driverName)) {
            if (DRIVER_MYSQL.equalsIgnoreCase(driverName)) {
                return new MysqlDialect();
            }
            if (DRIVER_ORACLE.equalsIgnoreCase(driverName)) {
                return new OracleDialect();
            }
            if (DRIVER_SQLLITE3.equalsIgnoreCase(driverName)) {
                return new Sqlite3Dialect();
            }
            if (DRIVER_POSTGRESQL.equalsIgnoreCase(driverName)) {
                return new PostgresqlDialect();
            }
            if (DRIVER_H2.equalsIgnoreCase(driverName)) {
                return new H2Dialect();
            }
            if (DRIVER_SQLSERVER.equalsIgnoreCase(driverName)) {
                return new SqlServer2012Dialect();
            }
        }
        return new AnsiSqlDialect();
    }

    public static String identifyDriver(String nameContainsProductInfo) {
        if (StrUtil.isBlank(nameContainsProductInfo)) {
            return null;
        }
        nameContainsProductInfo = nameContainsProductInfo.toLowerCase();
        String driver = null;
        if (nameContainsProductInfo.contains("mysql")) {
            driver = DRIVER_MYSQL;
        } else if (nameContainsProductInfo.contains("oracle")) {
            driver = DRIVER_ORACLE;
        } else if (nameContainsProductInfo.contains("postgresql")) {
            driver = DRIVER_POSTGRESQL;
        } else if (nameContainsProductInfo.contains("sqlite")) {
            driver = DRIVER_SQLLITE3;
        } else if (nameContainsProductInfo.contains("sqlserver")) {
            driver = DRIVER_SQLSERVER;
        } else if (nameContainsProductInfo.contains("hive")) {
            driver = DRIVER_HIVE;
        } else if (nameContainsProductInfo.contains("h2")) {
            driver = DRIVER_H2;
        } else if (nameContainsProductInfo.startsWith("jdbc:derby://")) {
            driver = DRIVER_DERBY;
        } else if (nameContainsProductInfo.contains("derby")) {
            driver = DRIVER_DERBY_EMBEDDED;
        }
        return driver;
    }

    public static Dialect newDialect(DataSource ds) {
        return DialectFactory.newDialect(DbUtil.identifyDriver(ds));
    }

    public static Dialect newDialect(Connection conn) {
        return DialectFactory.newDialect(DbUtil.identifyDriver(conn));
    }
}

