/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common.utilities;

import com.vertica.dsi.core.utilities.ClientInfoData;
import com.vertica.dsi.dataengine.impl.DSISimpleResultSet;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.DSITypeUtilities;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.utilities.MetaDataFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientInfoPropertiesMetadataSource
extends DSISimpleResultSet {
    private List<ClientInfoPropertyColumnInfo> m_columnData = null;
    private List<ColumnMetadata> m_columns = null;
    private int m_numRows;

    public ClientInfoPropertiesMetadataSource(Map<String, ClientInfoData> clientInfoPropertiesNames) {
        this.initializeData(clientInfoPropertiesNames);
        this.m_columns = MetaDataFactory.createClientInfoPropertiesMetadata();
    }

    @Override
    public boolean getData(int column, long offset, long maxSize, DataWrapper retrievedData) throws ErrorException {
        switch (column) {
            case 0: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columnData.get((int)this.getCurrentRow()).m_name, retrievedData, offset, maxSize);
            }
            case 1: {
                retrievedData.setInteger(this.m_columnData.get((int)this.getCurrentRow()).m_maxLength);
                return false;
            }
            case 2: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columnData.get((int)this.getCurrentRow()).m_defaultValue, retrievedData, offset, maxSize);
            }
            case 3: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columnData.get((int)this.getCurrentRow()).m_description, retrievedData, offset, maxSize);
            }
        }
        return false;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_numRows;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        return (ArrayList)this.m_columns;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        return this.getCurrentRow() + 1 < this.m_numRows;
    }

    @Override
    public boolean hasRowCount() {
        return true;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        this.m_columnData = null;
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        return this.getCurrentRow() < this.m_numRows;
    }

    private void initializeData(Map<String, ClientInfoData> clientInfoPropertiesNames) {
        this.m_columnData = new ArrayList<ClientInfoPropertyColumnInfo>();
        Set<String> keySet = clientInfoPropertiesNames.keySet();
        Object[] sortedNames = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(sortedNames, 0, sortedNames.length);
        ClientInfoPropertyColumnInfo currentRow = null;
        ClientInfoData currentClientInfoData = null;
        for (Object currentProperty : sortedNames) {
            currentClientInfoData = clientInfoPropertiesNames.get(currentProperty);
            currentRow = new ClientInfoPropertyColumnInfo();
            currentRow.m_name = currentClientInfoData.getName();
            currentRow.m_defaultValue = currentClientInfoData.getDefaultValue();
            currentRow.m_maxLength = currentClientInfoData.getMaxLength();
            currentRow.m_description = currentClientInfoData.getDescription();
            this.m_columnData.add(currentRow);
        }
        this.m_numRows = sortedNames.length;
    }

    private static class ClientInfoPropertyColumnInfo {
        public String m_name;
        public int m_maxLength;
        public String m_defaultValue;
        public String m_description;

        private ClientInfoPropertyColumnInfo() {
        }
    }
}

