/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.scf.runtime;

import com.alibaba.fastjson.JSONObject;
import com.qcloud.scf.runtime.HandlerInterface;
import com.qcloud.services.scf.runtime.events.APIGatewayProxyRequestEvent;
import com.qcloud.services.scf.runtime.events.APIGatewayProxyResponseEvent;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractSpringHandler
implements HandlerInterface {
    private static final String HOST_IP = "http://127.0.0.1:8080";
    private static volatile boolean cold_launch;

    public abstract void startApp();

    @Override
    public String mainHandler(APIGatewayProxyRequestEvent req) {
        if (cold_launch) {
            System.out.println("start spring");
            this.startApp();
            System.out.println("stop spring");
            cold_launch = false;
        }
        ResponseEntity<String> response = this.springHttpRequset(req);
        APIGatewayProxyResponseEvent resp = this.composeApiGWResponse(response);
        System.out.println("response body: " + (String)response.getBody());
        return resp.toString();
    }

    protected APIGatewayProxyResponseEvent composeApiGWResponse(ResponseEntity<String> response) {
        APIGatewayProxyResponseEvent resp = new APIGatewayProxyResponseEvent();
        resp.setIsBase64Encoded(false);
        resp.setStatusCode(response.getStatusCodeValue());
        HttpHeaders orgHeaders = response.getHeaders();
        JSONObject headerObj = new JSONObject();
        for (String key : orgHeaders.keySet()) {
            if (orgHeaders.getValuesAsList(key).size() > 1) {
                headerObj.put(key, (Object)orgHeaders.getValuesAsList(key));
                continue;
            }
            headerObj.put(key, orgHeaders.getValuesAsList(key).get(0));
        }
        resp.setHeaders(headerObj);
        resp.setBody((String)response.getBody());
        return resp;
    }

    protected ResponseEntity<String> springHttpRequset(APIGatewayProxyRequestEvent req) {
        String path = req.getPath();
        String method = req.getHttpMethod();
        String body = req.getBody();
        Map<String, String> hdrs = req.getHeaders();
        HttpMethod m = HttpMethod.resolve((String)method);
        HttpHeaders headers = new HttpHeaders();
        headers.setAll(hdrs);
        RestTemplate client = new RestTemplate();
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        String url = HOST_IP + path;
        return client.exchange(url, m, entity, String.class, new Object[0]);
    }

    static {
        System.out.println("initialize");
        cold_launch = true;
    }
}

