/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosPrepareStatement;
import com.taosdata.jdbc.common.Column;
import com.taosdata.jdbc.common.ColumnInfo;
import com.taosdata.jdbc.common.SerializeBlock;
import com.taosdata.jdbc.common.TableInfo;
import com.taosdata.jdbc.enums.FieldBindType;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.BlobUtil;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.ws.BlockResultSet;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSParameterMetaData;
import com.taosdata.jdbc.ws.WSRetryableStmt;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.stmt2.entity.Field;
import com.taosdata.jdbc.ws.stmt2.entity.RequestFactory;
import com.taosdata.jdbc.ws.stmt2.entity.ResultResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2PrepareResp;
import com.taosdata.jdbc.ws.stmt2.entity.StmtInfo;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class AbsWSPreparedStatement
extends WSRetryableStmt
implements TaosPrepareStatement {
    private static final List<Object> nullTag = Collections.singletonList(null);
    protected int queryTimeout = 0;
    protected final Map<Integer, Column> colOrderedMap = new HashMap<Integer, Column>();
    private final PriorityQueue<ColumnInfo> tag = new PriorityQueue();
    private final PriorityQueue<ColumnInfo> colListQueue = new PriorityQueue();
    private final HashMap<ByteBuffer, TableInfo> tableInfoMap = new HashMap();
    private TableInfo tableInfo;

    public AbsWSPreparedStatement(Transport transport, ConnectionParam param, String database, AbstractConnection connection, String sql, Long instanceId) {
        super(connection, param, database, transport, instanceId, new StmtInfo(sql), new AtomicInteger());
    }

    public AbsWSPreparedStatement(Transport transport, ConnectionParam param, String database, AbstractConnection connection, String sql, Long instanceId, Stmt2PrepareResp prepareResp) {
        super(connection, param, database, transport, instanceId, new StmtInfo(prepareResp, sql), new AtomicInteger());
        this.tableInfo = TableInfo.getEmptyTableInfo();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (seconds < 0) {
            throw TSDBError.createSQLException(8963);
        }
        this.queryTimeout = seconds;
        this.transport.setTimeout((long)seconds * 1000L);
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.stmtInfo.isInsert()) {
            this.executeUpdate();
        } else {
            this.executeQuery();
        }
        return !this.stmtInfo.isInsert();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.stmtInfo.isInsert()) {
            throw TSDBError.createSQLException(8963, "The query SQL must be prepared.");
        }
        if (!this.tag.isEmpty() || !this.colListQueue.isEmpty()) {
            throw TSDBError.createSQLException(8963, "The query SQL only support bind columns.");
        }
        if (this.colOrderedMap.isEmpty()) {
            return this.executeQuery(this.stmtInfo.getSql());
        }
        this.onlyBindCol();
        if (!this.isTableInfoEmpty()) {
            this.tableInfoMap.put(this.tableInfo.getTableName(), this.tableInfo);
        }
        ResultResp resp = this.executeQueryImpl();
        this.resultSet = new BlockResultSet(this, this.transport, resp, this.database, this.zoneId);
        this.affectedRows = -1;
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!this.stmtInfo.isInsert()) {
            throw TSDBError.createSQLException(8963, "The insert SQL must be prepared.");
        }
        if (this.stmtInfo.getFields().isEmpty()) {
            return this.executeUpdate(this.stmtInfo.getSql());
        }
        if (this.colOrderedMap.size() == this.stmtInfo.getFields().size()) {
            this.bindAllColWithStdApi();
        } else {
            this.onlyBindTag();
            this.onlyBindCol();
        }
        if (this.isTableInfoEmpty()) {
            throw TSDBError.createSQLException(8968, "no data to be bind");
        }
        this.tableInfoMap.put(this.tableInfo.getTableName(), this.tableInfo);
        return this.executeInsertImpl();
    }

    public void setTagSqlTypeNull(int index, int type) throws SQLException {
        switch (type) {
            case 16: {
                this.tag.add(new ColumnInfo(index, nullTag, 1));
                break;
            }
            case -6: {
                this.tag.add(new ColumnInfo(index, nullTag, 2));
                break;
            }
            case 5: {
                this.tag.add(new ColumnInfo(index, nullTag, 3));
                break;
            }
            case 4: {
                this.tag.add(new ColumnInfo(index, nullTag, 4));
                break;
            }
            case -5: {
                this.tag.add(new ColumnInfo(index, nullTag, 5));
                break;
            }
            case 6: {
                this.tag.add(new ColumnInfo(index, nullTag, 6));
                break;
            }
            case 8: {
                this.tag.add(new ColumnInfo(index, nullTag, 7));
                break;
            }
            case 93: {
                this.tag.add(new ColumnInfo(index, nullTag, 9));
                break;
            }
            case -2: 
            case 12: {
                this.tag.add(new ColumnInfo(index, nullTag, 8));
                break;
            }
            case -3: {
                this.tag.add(new ColumnInfo(index, nullTag, 16));
                break;
            }
            case 2004: {
                this.tag.add(new ColumnInfo(index, nullTag, 18));
                break;
            }
            case -15: {
                this.tag.add(new ColumnInfo(index, nullTag, 10));
                break;
            }
            case 1111: {
                this.tag.add(new ColumnInfo(index, nullTag, 15));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + type);
            }
        }
    }

    @Override
    public void setTagNull(int index, int type) throws SQLException {
        switch (type) {
            case 1: {
                this.tag.add(new ColumnInfo(index, nullTag, 1));
                break;
            }
            case 2: {
                this.tag.add(new ColumnInfo(index, nullTag, 2));
                break;
            }
            case 11: {
                this.tag.add(new ColumnInfo(index, nullTag, 11));
                break;
            }
            case 3: {
                this.tag.add(new ColumnInfo(index, nullTag, 3));
                break;
            }
            case 12: {
                this.tag.add(new ColumnInfo(index, nullTag, 12));
                break;
            }
            case 4: {
                this.tag.add(new ColumnInfo(index, nullTag, 4));
                break;
            }
            case 13: {
                this.tag.add(new ColumnInfo(index, nullTag, 13));
                break;
            }
            case 5: {
                this.tag.add(new ColumnInfo(index, nullTag, 5));
                break;
            }
            case 14: {
                this.tag.add(new ColumnInfo(index, nullTag, 14));
                break;
            }
            case 6: {
                this.tag.add(new ColumnInfo(index, nullTag, 6));
                break;
            }
            case 7: {
                this.tag.add(new ColumnInfo(index, nullTag, 7));
                break;
            }
            case 9: {
                this.tag.add(new ColumnInfo(index, nullTag, 9));
                break;
            }
            case 8: {
                this.tag.add(new ColumnInfo(index, nullTag, 8));
                break;
            }
            case 18: {
                this.tag.add(new ColumnInfo(index, nullTag, 18));
                break;
            }
            case 16: {
                this.tag.add(new ColumnInfo(index, nullTag, 16));
                break;
            }
            case 20: {
                this.tag.add(new ColumnInfo(index, nullTag, 20));
                break;
            }
            case 10: {
                this.tag.add(new ColumnInfo(index, nullTag, 10));
                break;
            }
            case 15: {
                this.tag.add(new ColumnInfo(index, nullTag, 15));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + type);
            }
        }
    }

    @Override
    public void setTagBoolean(int index, boolean value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 1));
    }

    @Override
    public void setTagByte(int index, byte value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 2));
    }

    @Override
    public void setTagShort(int index, short value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 3));
    }

    @Override
    public void setTagInt(int index, int value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 4));
    }

    @Override
    public void setTagLong(int index, long value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 5));
    }

    @Override
    public void setTagBigInteger(int index, BigInteger value) throws SQLException {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 5));
    }

    @Override
    public void setTagFloat(int index, float value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(Float.valueOf(value)), 6));
    }

    @Override
    public void setTagDouble(int index, double value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 7));
    }

    @Override
    public void setTagTimestamp(int index, long value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(new Timestamp(value)), 9));
    }

    @Override
    public void setTagTimestamp(int index, Timestamp value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(DateTimeUtils.toInstant(value, this.zoneId)), 9));
    }

    @Override
    public void setTagString(int index, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.tag.add(new ColumnInfo(index, Collections.singletonList(bytes), 8));
    }

    @Override
    public void setTagVarbinary(int index, byte[] value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 16));
    }

    @Override
    public void setTagGeometry(int index, byte[] value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value), 20));
    }

    @Override
    public void setTagNString(int index, String value) {
        this.tag.add(new ColumnInfo(index, Collections.singletonList(value.getBytes(StandardCharsets.UTF_8)), 10));
    }

    @Override
    public void setTagJson(int index, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.tag.add(new ColumnInfo(index, Collections.singletonList(bytes), 15));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 1, parameterIndex));
                break;
            }
            case -6: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 2, parameterIndex));
                break;
            }
            case 5: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 3, parameterIndex));
                break;
            }
            case 4: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 4, parameterIndex));
                break;
            }
            case -5: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 5, parameterIndex));
                break;
            }
            case 6: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 6, parameterIndex));
                break;
            }
            case 8: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 7, parameterIndex));
                break;
            }
            case 93: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 9, parameterIndex));
                break;
            }
            case -2: 
            case 12: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 8, parameterIndex));
                break;
            }
            case -3: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 16, parameterIndex));
                break;
            }
            case 2004: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 18, parameterIndex));
                break;
            }
            case -15: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 10, parameterIndex));
                break;
            }
            case 1111: {
                this.colOrderedMap.put(parameterIndex, new Column(null, 15, parameterIndex));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + sqlType);
            }
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(x, 1, parameterIndex));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(x, 2, parameterIndex));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(x, 3, parameterIndex));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(x, 4, parameterIndex));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(x, 5, parameterIndex));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(Float.valueOf(x), 6, parameterIndex));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(x, 7, parameterIndex));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        byte[] bytes = x.getBytes(StandardCharsets.UTF_8);
        this.setBytes(parameterIndex, bytes);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(x, 8, parameterIndex));
    }

    public void setVarbinary(int parameterIndex, byte[] x) throws SQLException {
        this.setBytes(parameterIndex, x);
    }

    public void setGeometry(int parameterIndex, byte[] x) throws SQLException {
        this.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Timestamp timestamp = new Timestamp(x.getTime());
        this.setTimestamp(parameterIndex, timestamp);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Timestamp timestamp = new Timestamp(x.getTime());
        this.setTimestamp(parameterIndex, timestamp);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.colOrderedMap.put(parameterIndex, new Column(DateTimeUtils.toInstant(x, this.zoneId), 9, parameterIndex));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void clearParameters() {
        this.colOrderedMap.clear();
        this.tag.clear();
        this.colListQueue.clear();
        this.tableInfo = TableInfo.getEmptyTableInfo();
        this.tableInfoMap.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case 16: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 1, parameterIndex));
                break;
            }
            case -6: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 2, parameterIndex));
                break;
            }
            case 5: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 3, parameterIndex));
                break;
            }
            case 4: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 4, parameterIndex));
                break;
            }
            case -5: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 5, parameterIndex));
                break;
            }
            case 6: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 6, parameterIndex));
                break;
            }
            case 8: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 7, parameterIndex));
                break;
            }
            case 93: {
                Instant instant = DateTimeUtils.toInstant((Timestamp)x, this.zoneId);
                this.colOrderedMap.put(parameterIndex, new Column(instant, 9, parameterIndex));
                break;
            }
            case -2: 
            case 12: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 8, parameterIndex));
                break;
            }
            case 2004: {
                if (x instanceof byte[]) {
                    this.colOrderedMap.put(parameterIndex, new Column(x, 18, parameterIndex));
                    break;
                }
                if (x instanceof Blob) {
                    Blob blob = (Blob)x;
                    byte[] bytes = blob.getBytes(1L, (int)blob.length());
                    this.colOrderedMap.put(parameterIndex, new Column(bytes, 18, parameterIndex));
                    break;
                }
                throw new SQLException("Unsupported BLOB type: " + x.getClass().getName());
            }
            case -3: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 16, parameterIndex));
                break;
            }
            case -15: {
                this.colOrderedMap.put(parameterIndex, new Column(x, 10, parameterIndex));
                break;
            }
            case 1111: {
                if (x instanceof Number) {
                    this.colOrderedMap.put(parameterIndex, new Column(x, 14, parameterIndex));
                    break;
                }
                this.colOrderedMap.put(parameterIndex, new Column(x, 15, parameterIndex));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + targetSqlType);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof String) {
            this.setBytes(parameterIndex, ((String)x).getBytes(StandardCharsets.UTF_8));
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof LocalDateTime) {
            if (this.zoneId == null) {
                this.setTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)x));
            } else {
                ZonedDateTime zonedDateTime = ((LocalDateTime)x).atZone(this.zoneId);
                Instant instant = zonedDateTime.toInstant();
                this.colOrderedMap.put(parameterIndex, new Column(instant, 9, parameterIndex));
            }
        } else if (x instanceof Instant) {
            this.colOrderedMap.put(parameterIndex, new Column(x, 9, parameterIndex));
        } else if (x instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)x;
            Instant instant = zonedDateTime.toInstant();
            this.colOrderedMap.put(parameterIndex, new Column(instant, 9, parameterIndex));
        } else if (x instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)x;
            Instant instant = offsetDateTime.toInstant();
            this.colOrderedMap.put(parameterIndex, new Column(instant, 9, parameterIndex));
        } else if (x instanceof BigInteger) {
            this.colOrderedMap.put(parameterIndex, new Column(x, 14, parameterIndex));
        } else if (x instanceof Blob) {
            byte[] bytes = ((Blob)x).getBytes(1L, (int)((Blob)x).length());
            this.colOrderedMap.put(parameterIndex, new Column(bytes, 18, parameterIndex));
        } else {
            throw new SQLException("Unsupported data type: " + x.getClass().getName());
        }
    }

    public static void bindAllToTableInfo(List<Field> fields, Map<Integer, Column> colOrderedMap, TableInfo tableInfo) {
        for (int index = 0; index < fields.size(); ++index) {
            LinkedList<Object> list;
            if (fields.get(index).getBindType() == FieldBindType.TAOS_FIELD_TBNAME.getValue()) {
                if (colOrderedMap.get(index + 1).getData() instanceof byte[]) {
                    tableInfo.setTableName(ByteBuffer.wrap((byte[])colOrderedMap.get(index + 1).getData()));
                }
                if (!(colOrderedMap.get(index + 1).getData() instanceof String)) continue;
                tableInfo.setTableName(ByteBuffer.wrap(((String)colOrderedMap.get(index + 1).getData()).getBytes(StandardCharsets.UTF_8)));
                continue;
            }
            if (fields.get(index).getBindType() == FieldBindType.TAOS_FIELD_TAG.getValue()) {
                list = new LinkedList<Object>();
                list.add(colOrderedMap.get(index + 1).getData());
                tableInfo.getTagInfo().add(new ColumnInfo(index + 1, list, fields.get(index).getFieldType()));
                continue;
            }
            if (fields.get(index).getBindType() != FieldBindType.TAOS_FIELD_COL.getValue()) continue;
            list = new LinkedList();
            list.add(colOrderedMap.get(index + 1).getData());
            tableInfo.getDataList().add(new ColumnInfo(index + 1, list, fields.get(index).getFieldType()));
        }
    }

    private void bindColToTableInfo(TableInfo tableInfo) {
        for (ColumnInfo columnInfo : tableInfo.getDataList()) {
            columnInfo.add(this.colOrderedMap.get(columnInfo.getIndex()).getData());
        }
    }

    private void bindAllColWithStdApi() throws SQLException {
        if (this.isTableInfoEmpty()) {
            AbsWSPreparedStatement.bindAllToTableInfo(this.stmtInfo.getFields(), this.colOrderedMap, this.tableInfo);
        } else if (this.stmtInfo.getToBeBindTableNameIndex() >= 0) {
            ByteBuffer tempTableName;
            Object tbname = this.colOrderedMap.get(this.stmtInfo.getToBeBindTableNameIndex() + 1).getData();
            if (tbname instanceof String) {
                tempTableName = ByteBuffer.wrap(((String)tbname).getBytes(StandardCharsets.UTF_8));
            } else if (tbname instanceof byte[]) {
                tempTableName = ByteBuffer.wrap((byte[])tbname);
            } else {
                throw TSDBError.createSQLException(8963, "table name must be string or binary");
            }
            if (this.tableInfo.getTableName().equals(tempTableName)) {
                this.bindColToTableInfo(this.tableInfo);
            } else if (this.tableInfoMap.containsKey(tempTableName)) {
                TableInfo tbInfo = this.tableInfoMap.get(tempTableName);
                this.bindColToTableInfo(tbInfo);
            } else {
                this.tableInfoMap.put(this.tableInfo.getTableName(), this.tableInfo);
                this.tableInfo = TableInfo.getEmptyTableInfo();
                AbsWSPreparedStatement.bindAllToTableInfo(this.stmtInfo.getFields(), this.colOrderedMap, this.tableInfo);
            }
        } else {
            this.bindColToTableInfo(this.tableInfo);
        }
    }

    private void onlyBindCol() {
        if (this.tableInfo.getDataList().isEmpty()) {
            for (Map.Entry<Integer, Column> entry : this.colOrderedMap.entrySet()) {
                Column col = entry.getValue();
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(col.getData());
                int type = col.getType();
                if (this.stmtInfo.isInsert()) {
                    type = this.stmtInfo.getColTypeList().get(col.getIndex() - 1).byteValue();
                }
                this.tableInfo.getDataList().add(new ColumnInfo(entry.getKey(), list, type));
            }
        } else {
            for (Map.Entry<Integer, Column> entry : this.colOrderedMap.entrySet()) {
                Column col = entry.getValue();
                this.tableInfo.getDataList().get(col.getIndex() - 1).add(col.getData());
            }
        }
    }

    private void onlyBindTag() throws SQLException {
        if (!this.tableInfo.getTagInfo().isEmpty()) {
            return;
        }
        if (this.stmtInfo.isInsert() && this.tag.size() != this.stmtInfo.getToBeBindTagCount()) {
            throw new SQLException("tag size is not equal to toBeBindTagCount");
        }
        while (!this.tag.isEmpty()) {
            ColumnInfo columnInfo = this.tag.poll();
            if (this.stmtInfo.isInsert() && columnInfo.getType() != this.stmtInfo.getTagTypeList().get(columnInfo.getIndex()).byteValue()) {
                this.tableInfo.getTagInfo().add(new ColumnInfo(columnInfo.getIndex(), columnInfo.getDataList(), this.stmtInfo.getTagTypeList().get(columnInfo.getIndex()).byteValue()));
                continue;
            }
            this.tableInfo.getTagInfo().add(columnInfo);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.colOrderedMap.size() == this.stmtInfo.getFields().size()) {
            this.bindAllColWithStdApi();
            return;
        }
        this.onlyBindTag();
        this.onlyBindCol();
    }

    private boolean isTableInfoEmpty() {
        return this.tableInfo.getTableName().capacity() == 0 && this.tableInfo.getTagInfo().isEmpty() && this.tableInfo.getDataList().isEmpty();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!this.isTableInfoEmpty()) {
            this.tableInfoMap.put(this.tableInfo.getTableName(), this.tableInfo);
        }
        int affected = this.executeInsertImpl();
        int[] ints = new int[affected];
        int len = ints.length;
        for (int i = 0; i < len; ++i) {
            ints[i] = -2;
        }
        return ints;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (this.transport.isConnected() && this.stmtInfo.getStmtId() != 0L) {
                long reqId = ReqId.getReqID();
                Request close = RequestFactory.generateClose(this.stmtInfo.getStmtId(), reqId);
                this.transport.send(close);
            }
            super.close();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.getResultSet() == null) {
            return null;
        }
        return this.getResultSet().getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (!this.tag.isEmpty()) {
            ColumnInfo columnInfo = this.tag.poll();
            if (columnInfo.getDataList().size() != 1) {
                throw new SQLException("tag size is not equal 1");
            }
            list.add(columnInfo.getDataList().get(0));
        }
        if (!this.colOrderedMap.isEmpty()) {
            this.colOrderedMap.keySet().stream().sorted().forEach(i -> {
                Column col = this.colOrderedMap.get(i);
                list.add(col.getData());
            });
        }
        return new WSParameterMetaData(this.stmtInfo.isInsert(), this.stmtInfo.getFields(), this.stmtInfo.getColTypeList());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkBlobSupport();
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.colOrderedMap.put(parameterIndex, new Column(BlobUtil.getBytes(x), 18, parameterIndex));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Instant instant = DateTimeUtils.toInstant(x, cal);
        this.colOrderedMap.put(parameterIndex, new Column(instant, 9, parameterIndex));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (value == null) {
            this.setNull(parameterIndex, -15);
            return;
        }
        this.colOrderedMap.put(parameterIndex, new Column(value.getBytes(StandardCharsets.UTF_8), 10, parameterIndex));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkBlobSupport();
        this.colOrderedMap.put(parameterIndex, new Column(BlobUtil.getFromInputStream(inputStream, length), 8, parameterIndex));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkBlobSupport();
        this.colOrderedMap.put(parameterIndex, new Column(BlobUtil.getFromInputStream(inputStream), 8, parameterIndex));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setInt(int columnIndex, List<Integer> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 4, 4);
    }

    @Override
    public void setFloat(int columnIndex, List<Float> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 6, 4);
    }

    @Override
    public void setTimestamp(int columnIndex, List<Long> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 9, 8);
    }

    @Override
    public void setLong(int columnIndex, List<Long> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 5, 8);
    }

    @Override
    public void setBigInteger(int columnIndex, List<BigInteger> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 14, 8);
    }

    @Override
    public void setDouble(int columnIndex, List<Double> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 7, 8);
    }

    @Override
    public void setBoolean(int columnIndex, List<Boolean> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 1, 1);
    }

    @Override
    public void setByte(int columnIndex, List<Byte> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 2, 1);
    }

    @Override
    public void setShort(int columnIndex, List<Short> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 3, 2);
    }

    @Override
    public void setString(int columnIndex, List<String> list, int size) throws SQLException {
        List collect = list.stream().map(x -> {
            if (x == null) {
                return null;
            }
            return x.getBytes(StandardCharsets.UTF_8);
        }).collect(Collectors.toList());
        this.setValueImpl(columnIndex, collect, 8, size);
    }

    @Override
    public void setVarbinary(int columnIndex, List<byte[]> list, int size) throws SQLException {
        this.setValueImpl(columnIndex, list, 16, size);
    }

    @Override
    public void setGeometry(int columnIndex, List<byte[]> list, int size) throws SQLException {
        this.setValueImpl(columnIndex, list, 20, size);
    }

    @Override
    public void setBlob(int columnIndex, List<Blob> list, int size) throws SQLException {
        this.checkBlobSupport();
        this.setValueImpl(columnIndex, BlobUtil.getListBytes(list), 18, size);
    }

    @Override
    public void setNString(int columnIndex, List<String> list, int size) throws SQLException {
        List collect = list.stream().map(x -> {
            if (x == null) {
                return null;
            }
            return x.getBytes(StandardCharsets.UTF_8);
        }).collect(Collectors.toList());
        this.setValueImpl(columnIndex, collect, 10, size);
    }

    public <T> void setValueImpl(int columnIndex, List<T> list, int type, int bytes) throws SQLException {
        ArrayList<Object> listObject = new ArrayList<Object>(list);
        if (this.stmtInfo.isInsert()) {
            type = this.stmtInfo.getColTypeList().get(columnIndex).byteValue();
        }
        ColumnInfo p = new ColumnInfo(columnIndex, listObject, type);
        this.colListQueue.add(p);
    }

    @Override
    public void columnDataAddBatch() throws SQLException {
        ColumnInfo columnInfo;
        if (!this.colOrderedMap.isEmpty()) {
            throw new SQLException("column data is not empty");
        }
        while (!this.tag.isEmpty()) {
            columnInfo = this.tag.poll();
            if (this.stmtInfo.isInsert() && columnInfo.getType() != this.stmtInfo.getTagTypeList().get(columnInfo.getIndex()).byteValue()) {
                this.tableInfo.getTagInfo().add(new ColumnInfo(columnInfo.getIndex(), columnInfo.getDataList(), this.stmtInfo.getTagTypeList().get(columnInfo.getIndex()).byteValue()));
                continue;
            }
            this.tableInfo.getTagInfo().add(columnInfo);
        }
        while (!this.colListQueue.isEmpty()) {
            columnInfo = this.colListQueue.poll();
            if (this.stmtInfo.isInsert() && columnInfo.getType() != this.stmtInfo.getColTypeList().get(columnInfo.getIndex()).byteValue()) {
                this.tableInfo.getDataList().add(new ColumnInfo(columnInfo.getIndex(), columnInfo.getDataList(), this.stmtInfo.getColTypeList().get(columnInfo.getIndex()).byteValue()));
                continue;
            }
            this.tableInfo.getDataList().add(columnInfo);
        }
        if (this.tableInfoMap.containsKey(this.tableInfo.getTableName())) {
            TableInfo tbInfo = this.tableInfoMap.get(this.tableInfo.getTableName());
            tbInfo.getDataList().addAll(this.tableInfo.getDataList());
            tbInfo.getTagInfo().addAll(this.tableInfo.getTagInfo());
        } else {
            this.tableInfoMap.put(this.tableInfo.getTableName(), this.tableInfo);
        }
        this.tableInfo = TableInfo.getEmptyTableInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInsertImpl() throws SQLException {
        ByteBuf rawBlock;
        if (this.tableInfoMap.isEmpty()) {
            throw new SQLException("batch data is empty");
        }
        long reqId = ReqId.getReqID();
        try {
            rawBlock = SerializeBlock.getStmt2BindBlock(this.tableInfoMap, this.stmtInfo, reqId);
        }
        finally {
            this.clearParameters();
        }
        this.writeBlockWithRetrySync(rawBlock);
        this.affectedRows = this.batchInsertedRows.getAndSet(0);
        return this.affectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultResp executeQueryImpl() throws SQLException {
        ByteBuf rawBlock;
        if (this.tableInfoMap.isEmpty()) {
            throw new SQLException("batch data is empty");
        }
        long reqId = ReqId.getReqID();
        try {
            rawBlock = SerializeBlock.getStmt2BindBlock(this.tableInfoMap, this.stmtInfo, reqId);
        }
        finally {
            this.clearParameters();
        }
        return this.queryWithRetry(rawBlock);
    }

    @Override
    public void columnDataExecuteBatch() throws SQLException {
        this.executeInsertImpl();
    }

    public void columnDataCloseBatch() throws SQLException {
        this.close();
    }

    @Override
    public void setTableName(String name) throws SQLException {
        this.tableInfo.setTableName(ByteBuffer.wrap(name.getBytes(StandardCharsets.UTF_8)));
    }
}

