/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.common;

import com.taosdata.jdbc.common.Consumer;
import com.taosdata.jdbc.common.ConsumerFactory;
import java.io.PrintWriter;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConsumerManager {
    private static final CopyOnWriteArrayList<ConsumerFactory> registeredConsumers = new CopyOnWriteArrayList();
    private static final Object logSync = new Object();
    private static PrintWriter logWriter = null;

    private ConsumerManager() {
    }

    private static void loadConsumerFactories() {
        AccessController.doPrivileged(() -> {
            ServiceLoader<ConsumerFactory> consumerFactoryLoader = ServiceLoader.load(ConsumerFactory.class);
            Iterator<ConsumerFactory> iterator = consumerFactoryLoader.iterator();
            try {
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        });
    }

    public static void register(ConsumerFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        registeredConsumers.addIfAbsent(factory);
        ConsumerManager.println("registerConsumerFactory: " + factory);
    }

    public static Consumer<?> getConsumer(String type) throws SQLException {
        for (ConsumerFactory factory : registeredConsumers) {
            Consumer<?> consumer;
            if (!factory.acceptsType(type) || (consumer = factory.getConsumer()) == null) continue;
            ConsumerManager.println("getConsumerFactory returning " + factory.getClass().getName());
            return consumer;
        }
        ConsumerManager.println("getConsumer: no suitable consumer found for " + type);
        throw new SQLException("No suitable consumer found for " + type, "");
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(PrintWriter out) {
        logWriter = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String message) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(message);
                logWriter.flush();
            }
        }
    }

    static {
        ConsumerManager.loadConsumerFactories();
    }
}

