/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.FetchDataUtil;
import com.taosdata.jdbc.utils.JsonUtil;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.utils.VersionUtil;
import com.taosdata.jdbc.ws.FetchBlockData;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSConnection;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.FetchBlockNewResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDriver
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(AbstractDriver.class);

    protected DriverPropertyInfo[] getPropertyInfo(Properties info) {
        DriverPropertyInfo hostProp = new DriverPropertyInfo("host", info.getProperty("host"));
        hostProp.required = false;
        hostProp.description = "Hostname";
        DriverPropertyInfo portProp = new DriverPropertyInfo("port", info.getProperty("port"));
        portProp.required = false;
        portProp.description = "Port";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("dbname", info.getProperty("dbname"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = "User";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = "Password";
        DriverPropertyInfo[] propertyInfo = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp};
        return propertyInfo;
    }

    protected Connection getWSConnection(String url, ConnectionParam param, Properties props) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("getWSConnection, url = {}", (Object)StringUtils.getBasicUrl(url));
            try {
                ObjectMapper objectMapper = JsonUtil.getObjectMapper();
                log.debug("getWSConnection, ConnectionParam = {}", (Object)objectMapper.writeValueAsString((Object)param));
            }
            catch (JsonProcessingException e) {
                log.error("Error serializing ConnectionParam", (Throwable)e);
            }
        }
        InFlightRequest inFlightRequest = new InFlightRequest(param.getRequestTimeout(), param.getMaxRequest());
        param.setTextMessageHandler(message -> {
            try {
                log.trace("received message: {}", message);
                JsonNode jsonObject = JsonUtil.getObjectReader().readTree(message);
                Action action = Action.of(jsonObject.get("action").asText());
                ObjectReader actionReader = JsonUtil.getObjectReader(action.getResponseClazz());
                Response response = (Response)actionReader.treeToValue((TreeNode)jsonObject, action.getResponseClazz());
                FutureResponse remove = inFlightRequest.remove(response.getAction(), response.getReqId());
                if (null != remove) {
                    remove.getFuture().complete(response);
                }
            }
            catch (JsonProcessingException e) {
                log.error("Error processing message", (Throwable)e);
            }
        });
        param.setBinaryMessageHandler(byteBuf -> {
            byteBuf.readerIndex(26);
            long id = byteBuf.readLongLE();
            byteBuf.readerIndex(8);
            FetchBlockData fetchBlockData = FetchDataUtil.getFetchMap().get(id);
            if (null != fetchBlockData) {
                Utils.retainByteBuf(byteBuf);
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.getBytes(byteBuf.readerIndex(), bytes);
                FetchBlockNewResp fetchBlockResp = new FetchBlockNewResp((ByteBuf)byteBuf);
                try {
                    fetchBlockData.handleReceiveBlockData(fetchBlockResp);
                }
                catch (InterruptedException e) {
                    log.error("Error handling fetch block data", (Throwable)e);
                    Thread.currentThread().interrupt();
                    Utils.releaseByteBuf(byteBuf);
                }
                catch (Exception e) {
                    Utils.releaseByteBuf(byteBuf);
                    log.error("Unexpected error handling fetch block data, id: {}", (Object)id, (Object)e);
                }
            } else {
                log.trace("Received fetch block new response, but no fetch data found for id: {}", (Object)id);
            }
        });
        Transport transport = new Transport(WSFunction.WS, param, inFlightRequest);
        transport.checkConnection(param.getConnectTimeout());
        ConnectReq connectReq = new ConnectReq(param);
        ConnectResp auth = (ConnectResp)transport.send(new Request(Action.CONN.getAction(), connectReq));
        if (Code.SUCCESS.getCode() != auth.getCode()) {
            transport.close();
            throw new SQLException("(0x" + Integer.toHexString(auth.getCode()) + "):auth failure:" + auth.getMessage());
        }
        String version = auth.getVersion();
        if (version == null) {
            version = VersionUtil.getVersion(transport);
        }
        if (!VersionUtil.checkVersion(version)) {
            transport.close();
            throw TSDBError.createSQLException(8993, "minimal supported version is 3.3.6.0, but got " + version);
        }
        TaosGlobalConfig.setCharset(StandardCharsets.UTF_8.name());
        return new WSConnection(url, props, transport, param, version);
    }
}

