/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractParameterMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.DataType;
import com.taosdata.jdbc.enums.FieldBindType;
import com.taosdata.jdbc.ws.stmt2.entity.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class WSParameterMetaData
extends AbstractParameterMetaData {
    private final ArrayList<Byte> colTypeList;
    private final boolean isInsert;
    private final List<Field> fields;

    public WSParameterMetaData(boolean isInsert, List<Field> fields, ArrayList<Byte> parameters) {
        super(null);
        this.colTypeList = parameters;
        this.isInsert = isInsert;
        this.fields = fields;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.colTypeList == null ? 0 : this.colTypeList.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        if (!this.isInsert) {
            return 1;
        }
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (this.fields.get(param - 1).getBindType() == FieldBindType.TAOS_FIELD_TBNAME.getValue()) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (!this.isInsert) {
            return false;
        }
        return this.colTypeList.get(param - 1) == 2 || this.colTypeList.get(param - 1) == 3 || this.colTypeList.get(param - 1) == 4 || this.colTypeList.get(param - 1) == 5 || this.colTypeList.get(param - 1) == 6 || this.colTypeList.get(param - 1) == 7 || this.colTypeList.get(param - 1) == 21 || this.colTypeList.get(param - 1) == 17;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (!this.isInsert) {
            return 0;
        }
        return this.fields.get(param - 1).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (!this.isInsert) {
            return 0;
        }
        return this.fields.get(param - 1).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (!this.isInsert) {
            return 1111;
        }
        byte colType = this.colTypeList.get(param - 1);
        return DataType.convertTaosType2DataType(colType).getJdbcTypeValue();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (!this.isInsert) {
            return "";
        }
        byte colType = this.colTypeList.get(param - 1);
        return DataType.convertTaosType2DataType(colType).getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        if (!this.isInsert) {
            return "";
        }
        byte colType = this.colTypeList.get(param - 1);
        return DataType.convertTaosType2DataType(colType).getClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        if (param < 1 && param >= this.colTypeList.size()) {
            throw TSDBError.createSQLException(8973);
        }
        return 1;
    }
}

