/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.google.common.base.Strings;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.Request;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSClient
extends WebSocketClient
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(WSClient.class);
    ThreadPoolExecutor executor;
    Transport transport;
    ConnectionParam connectionParam;
    private Consumer<String> textMessageHandler;
    private Consumer<ByteBuffer> binaryMessageHandler;
    private final WSFunction wsFunction;

    public void setTextMessageHandler(Consumer<String> textMessageHandler) {
        this.textMessageHandler = textMessageHandler;
    }

    public void setBinaryMessageHandler(Consumer<ByteBuffer> binaryMessageHandler) {
        this.binaryMessageHandler = binaryMessageHandler;
    }

    public WSClient(URI serverUri, Transport transport, ConnectionParam connectionParam, WSFunction function) {
        super(serverUri, new HashMap());
        this.transport = transport;
        this.connectionParam = connectionParam;
        this.wsFunction = function;
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r);
            t.setName("parse-message-" + t.getId());
            return t;
        }, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void onOpen(ServerHandshake serverHandshake) {
    }

    public void onMessage(String message) {
        if (!"".equals(message)) {
            this.executor.submit(() -> this.textMessageHandler.accept(message));
        }
    }

    public void onMessage(ByteBuffer bytes) {
        this.executor.submit(() -> this.binaryMessageHandler.accept(bytes));
    }

    public void onClose(int code, String reason, boolean remote) {
        this.log.error("code : " + code + " , reason: " + reason + " remote:" + remote + " wsclient:" + this);
    }

    public void onError(Exception e) {
        this.close();
    }

    public void shutdown() {
        super.close();
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    public boolean reconnectBlockingWithoutRetry() throws InterruptedException {
        return super.reconnectBlocking();
    }

    public boolean reconnectBlocking() {
        if (WSFunction.TMQ.equals((Object)this.wsFunction)) {
            return false;
        }
        int MAX_CONNECT_RETRY_COUNT = 3;
        for (int retryTimes = 0; retryTimes < 3; ++retryTimes) {
            try {
                if (super.reconnectBlocking()) {
                    ConnectReq connectReq = new ConnectReq();
                    connectReq.setReqId(ReqId.getReqID());
                    connectReq.setUser(this.connectionParam.getUser());
                    connectReq.setPassword(this.connectionParam.getPassword());
                    connectReq.setDb(this.connectionParam.getDatabase());
                    if (this.connectionParam.getConnectMode() != 0) {
                        connectReq.setMode(this.connectionParam.getConnectMode());
                    }
                    ConnectResp auth = (ConnectResp)this.transport.send(new Request(Action.CONN.getAction(), connectReq));
                    if (Code.SUCCESS.getCode() == auth.getCode()) {
                        return true;
                    }
                }
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception e) {
                this.log.error("try connect remote server failed!", (Throwable)e);
            }
        }
        return false;
    }

    public static WSClient getInstance(ConnectionParam params, WSFunction function, Transport transport) throws SQLException {
        URI urlPath;
        if (Strings.isNullOrEmpty((String)function.getFunction())) {
            throw new SQLException("websocket url error");
        }
        String protocol = "ws";
        if (params.isUseSsl()) {
            protocol = "wss";
        }
        String port = "";
        if (null != params.getPort()) {
            port = ":" + params.getPort();
        }
        String wsFunction = "/ws";
        if (function.equals((Object)WSFunction.TMQ)) {
            wsFunction = "/rest/tmq";
        }
        String loginUrl = protocol + "://" + params.getHost() + port + wsFunction;
        if (null != params.getCloudToken()) {
            loginUrl = loginUrl + "?token=" + params.getCloudToken();
        }
        try {
            urlPath = new URI(loginUrl);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Websocket url parse error: " + loginUrl, e);
        }
        return new WSClient(urlPath, transport, params, function);
    }
}

