/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulDatabaseMetaData;
import com.taosdata.jdbc.rs.RestfulPreparedStatement;
import com.taosdata.jdbc.rs.RestfulStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class RestfulConnection
extends AbstractConnection {
    private final String host;
    private final String port;
    private final String url;
    private final String database;
    private final String auth;
    private final boolean useSsl;
    private final String token;
    private final String tz;
    private boolean isClosed;
    private final DatabaseMetaData metadata;

    public RestfulConnection(String host, String port, Properties props, String database, String url, String auth, boolean useSsl, String token, String tz) {
        super(props);
        this.host = host;
        this.port = port;
        this.database = database;
        this.url = url;
        this.auth = auth == null ? null : "Basic " + auth;
        this.useSsl = useSsl;
        this.token = token;
        this.tz = tz;
        this.metadata = new RestfulDatabaseMetaData(url, props.getProperty("user"), this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return new RestfulStatement(this, this.database);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return new RestfulPreparedStatement(this, this.database, sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.metadata;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getAuth() {
        return this.auth;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public String getTz() {
        return this.tz;
    }
}

