/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.TSDBError;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionParam {
    private String host;
    private String port;
    private String database;
    private String cloudToken;
    private String user;
    private String password;
    private String tz;
    private boolean useSsl;
    private int maxRequest;
    private int connectTimeout;
    private int requestTimeout;
    private int connectMode;
    public static final int CONNECT_MODE_BI = 1;

    private ConnectionParam(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.database = builder.database;
        this.cloudToken = builder.cloudToken;
        this.user = builder.user;
        this.password = builder.password;
        this.tz = builder.tz;
        this.useSsl = builder.useSsl;
        this.maxRequest = builder.maxRequest;
        this.connectTimeout = builder.connectTimeout;
        this.requestTimeout = builder.requestTimeout;
        this.connectMode = builder.connectMode;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCloudToken() {
        return this.cloudToken;
    }

    public void setCloudToken(String cloudToken) {
        this.cloudToken = cloudToken;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String tz) {
        this.tz = tz;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public int getMaxRequest() {
        return this.maxRequest;
    }

    public void setMaxRequest(int maxRequest) {
        this.maxRequest = maxRequest;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getConnectMode() {
        return this.connectMode;
    }

    public void setConnectMode(int connectMode) {
        this.connectMode = connectMode;
    }

    public static ConnectionParam getParam(Properties properties) throws SQLException {
        String host = properties.getProperty("host");
        String port = properties.getProperty("port");
        String database = properties.containsKey("dbname") ? properties.getProperty("dbname") : null;
        String cloudToken = null;
        if (properties.containsKey("token")) {
            cloudToken = properties.getProperty("token");
        }
        String user = properties.getProperty("user");
        String password = properties.getProperty("password");
        if (user == null && cloudToken == null) {
            throw TSDBError.createSQLException(8985);
        }
        if (password == null && cloudToken == null) {
            throw TSDBError.createSQLException(8986);
        }
        try {
            if (user != null) {
                user = URLDecoder.decode(user, StandardCharsets.UTF_8.displayName());
            }
            if (password != null) {
                password = URLDecoder.decode(password, StandardCharsets.UTF_8.displayName());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw TSDBError.createSQLException(8963, "unsupported UTF-8 concoding, user: " + properties.getProperty("user") + ", password: " + properties.getProperty("password"));
        }
        String tz = properties.getProperty("tz");
        boolean useSsl = Boolean.parseBoolean(properties.getProperty("useSSL", "false"));
        int maxRequest = Integer.parseInt(properties.getProperty("httpPoolSize", "20"));
        int connectTimeout = Integer.parseInt(properties.getProperty("httpConnectTimeout", "60000"));
        int requestTimeout = Integer.parseInt(properties.getProperty("messageWaitTimeout", String.valueOf(60000)));
        int connectMode = Integer.parseInt(properties.getProperty("conmode", "0"));
        if (connectMode < 0 || connectMode > 1) {
            throw TSDBError.createSQLException(8963, "unsupported connect mode");
        }
        return new Builder(host, port).setDatabase(database).setCloudToken(cloudToken).setUserAndPassword(user, password).setTimeZone(tz).setUseSsl(useSsl).setMaxRequest(maxRequest).setConnectionTimeout(connectTimeout).setRequestTimeout(requestTimeout).setConnectMode(connectMode).build();
    }

    public static class Builder {
        private final String host;
        private final String port;
        private String database;
        private String cloudToken;
        private String user;
        private String password;
        private String tz;
        private boolean useSsl;
        private int maxRequest;
        private int connectTimeout;
        private int requestTimeout;
        private int connectMode;

        public Builder(String host, String port) {
            this.host = host;
            this.port = port;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setCloudToken(String cloudToken) {
            this.cloudToken = cloudToken;
            return this;
        }

        public Builder setUserAndPassword(String user, String password) {
            this.user = user;
            this.password = password;
            return this;
        }

        public Builder setTimeZone(String timeZone) {
            this.tz = timeZone;
            return this;
        }

        public Builder setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder setMaxRequest(int maxRequest) {
            this.maxRequest = maxRequest;
            return this;
        }

        public Builder setConnectionTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder setConnectMode(int connectMode) {
            this.connectMode = connectMode;
            return this;
        }

        public ConnectionParam build() {
            return new ConnectionParam(this);
        }
    }
}

