/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.utils.NullType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TSDBResultSetBlockData {
    private int numOfRows = 0;
    private int rowIndex = 0;
    private List<ColumnMetaData> columnMetaDataList;
    private ArrayList<Object> colData;

    public TSDBResultSetBlockData(List<ColumnMetaData> colMeta, int numOfCols) {
        this.columnMetaDataList = colMeta;
        this.colData = new ArrayList(numOfCols);
    }

    public TSDBResultSetBlockData() {
        this.colData = new ArrayList();
    }

    public void clear() {
        int size = this.colData.size();
        this.colData.clear();
        this.setNumOfCols(size);
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public void setNumOfRows(int numOfRows) {
        this.numOfRows = numOfRows;
    }

    public int getNumOfCols() {
        return this.colData.size();
    }

    public void setNumOfCols(int numOfCols) {
        this.colData = new ArrayList(numOfCols);
        this.colData.addAll(Collections.nCopies(numOfCols, null));
    }

    public boolean hasMore() {
        return this.rowIndex < this.numOfRows;
    }

    public boolean forward() {
        if (this.rowIndex > this.numOfRows) {
            return false;
        }
        return ++this.rowIndex < this.numOfRows;
    }

    public void reset() {
        this.rowIndex = 0;
    }

    public void setBoolean(int col, boolean value) {
        this.colData.set(col, value);
    }

    public void setByteArray(int col, int length, byte[] value) {
        try {
            switch (this.columnMetaDataList.get(col).getColType()) {
                case 1: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    buf.order(ByteOrder.LITTLE_ENDIAN).asCharBuffer();
                    this.colData.set(col, buf);
                    break;
                }
                case 2: 
                case 11: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    this.colData.set(col, buf);
                    break;
                }
                case 3: 
                case 12: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    ShortBuffer sb = buf.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
                    this.colData.set(col, sb);
                    break;
                }
                case 4: 
                case 13: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    IntBuffer ib = buf.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                    this.colData.set(col, ib);
                    break;
                }
                case 5: 
                case 14: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    LongBuffer lb = buf.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
                    this.colData.set(col, lb);
                    break;
                }
                case 6: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    FloatBuffer fb = buf.order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
                    this.colData.set(col, fb);
                    break;
                }
                case 7: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    DoubleBuffer db = buf.order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
                    this.colData.set(col, db);
                    break;
                }
                case 8: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    this.colData.set(col, buf);
                    break;
                }
                case 9: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    LongBuffer lb = buf.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
                    this.colData.set(col, lb);
                    break;
                }
                case 10: {
                    ByteBuffer buf = ByteBuffer.wrap(value, 0, length);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    this.colData.set(col, buf);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getString(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            return new NullType().toString();
        }
        return obj.toString();
    }

    public int getInt(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return 0;
        }
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return (Integer)obj;
            }
            case 5: 
            case 9: {
                return ((Long)obj).intValue();
            }
            case 6: 
            case 7: {
                return ((Double)obj).intValue();
            }
            case 8: 
            case 10: {
                return Integer.parseInt((String)obj);
            }
        }
        return 0;
    }

    public boolean getBoolean(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            return Boolean.FALSE;
        }
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return (long)((Integer)obj).intValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 5: 
            case 9: {
                return (Long)obj == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 6: 
            case 7: {
                return (Double)obj == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 8: 
            case 10: {
                if ("TRUE".compareToIgnoreCase((String)obj) == 0) {
                    return Boolean.TRUE;
                }
                if ("FALSE".compareToIgnoreCase((String)obj) == 0) {
                    return Boolean.TRUE;
                }
                throw new SQLDataException();
            }
        }
        return Boolean.FALSE;
    }

    public long getLong(int col) throws SQLException {
        Object obj = this.get(col);
        if (obj == null) {
            return 0L;
        }
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return (Long)obj;
            }
            case 6: 
            case 7: {
                return ((Double)obj).longValue();
            }
            case 8: 
            case 10: {
                return Long.parseLong((String)obj);
            }
        }
        return 0L;
    }

    public Timestamp getTimestamp(int col) {
        try {
            return new Timestamp(this.getLong(col));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public double getDouble(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return 0.0;
        }
        int type = this.columnMetaDataList.get(col).getColType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((Integer)obj).intValue();
            }
            case 5: 
            case 9: {
                return ((Long)obj).longValue();
            }
            case 6: 
            case 7: {
                return (Double)obj;
            }
            case 8: 
            case 10: {
                return Double.parseDouble((String)obj);
            }
        }
        return 0.0;
    }

    public Object get(int col) {
        int fieldSize = this.columnMetaDataList.get(col).getColSize();
        switch (this.columnMetaDataList.get(col).getColType()) {
            case 1: {
                ByteBuffer bb = (ByteBuffer)this.colData.get(col);
                byte val = bb.get(this.rowIndex);
                if (NullType.isBooleanNull(val)) {
                    return null;
                }
                return val == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 2: {
                ByteBuffer bb = (ByteBuffer)this.colData.get(col);
                byte val = bb.get(this.rowIndex);
                if (NullType.isTinyIntNull(val)) {
                    return null;
                }
                return val;
            }
            case 3: {
                ShortBuffer sb = (ShortBuffer)this.colData.get(col);
                short val = sb.get(this.rowIndex);
                if (NullType.isSmallIntNull(val)) {
                    return null;
                }
                return val;
            }
            case 4: {
                IntBuffer ib = (IntBuffer)this.colData.get(col);
                int val = ib.get(this.rowIndex);
                if (NullType.isIntNull(val)) {
                    return null;
                }
                return val;
            }
            case 5: 
            case 9: {
                LongBuffer lb = (LongBuffer)this.colData.get(col);
                long val = lb.get(this.rowIndex);
                if (NullType.isBigIntNull(val)) {
                    return null;
                }
                return val;
            }
            case 6: {
                FloatBuffer fb = (FloatBuffer)this.colData.get(col);
                float val = fb.get(this.rowIndex);
                if (NullType.isFloatNull(val)) {
                    return null;
                }
                return Float.valueOf(val);
            }
            case 7: {
                DoubleBuffer lb = (DoubleBuffer)this.colData.get(col);
                double val = lb.get(this.rowIndex);
                if (NullType.isDoubleNull(val)) {
                    return null;
                }
                return val;
            }
            case 8: {
                ByteBuffer bb = (ByteBuffer)this.colData.get(col);
                bb.position(fieldSize * this.rowIndex);
                short length = bb.getShort();
                byte[] dest = new byte[length];
                bb.get(dest, 0, length);
                if (NullType.isBinaryNull(dest, length)) {
                    return null;
                }
                return new String(dest);
            }
            case 10: {
                ByteBuffer bb = (ByteBuffer)this.colData.get(col);
                bb.position(fieldSize * this.rowIndex);
                short length = bb.getShort();
                byte[] dest = new byte[length];
                bb.get(dest, 0, length);
                if (NullType.isNcharNull(dest, length)) {
                    return null;
                }
                try {
                    String charset = TaosGlobalConfig.getCharset();
                    return new String(dest, charset);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }
}

