/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractDatabaseMetaData;
import com.taosdata.jdbc.TSDBDriver;
import com.taosdata.jdbc.TSDBError;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TSDBDatabaseMetaData
extends AbstractDatabaseMetaData {
    private String url;
    private String userName;
    private Connection conn;

    public TSDBDatabaseMetaData(String url, String userName) {
        this.url = url;
        this.userName = userName;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public String getURL() throws SQLException {
        return this.url;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName;
    }

    @Override
    public String getDriverName() throws SQLException {
        return TSDBDriver.class.getName();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getTables(catalog, schemaPattern, tableNamePattern, types, this.conn);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getCatalogs(this.conn);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getTableTypes();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern, this.conn);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getPrimaryKeys(catalog, schema, table, this.conn);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getSuperTables(catalog, schemaPattern, tableNamePattern, this.conn);
    }
}

