/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.LineReader;
import com.taobao.text.RenderAppendable;
import com.taobao.text.Style;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.util.BlankSequence;
import com.taobao.text.util.Pair;

class LabelReader
implements LineReader {
    private final LabelElement element;
    private final Pair<Integer, Integer>[] lines;
    private final int width;
    private final int height;
    private int index = 0;

    LabelReader(LabelElement element, Pair<Integer, Integer>[] lines, int width, int height) {
        this.element = element;
        this.lines = lines;
        this.height = height;
        this.width = width;
    }

    @Override
    public boolean hasLine() {
        return this.index < this.height;
    }

    @Override
    public void renderLine(RenderAppendable to) {
        if (this.index >= this.height) {
            throw new IllegalStateException();
        }
        Style.Composite style = this.element.getStyle();
        if (style != null) {
            to.enterStyle(style);
        }
        if (this.index < this.lines.length) {
            Pair<Integer, Integer> a = this.lines[this.index];
            to.append(this.element.value, a.getFirst(), a.getSecond());
            int missing = this.width - (a.getSecond() - a.getFirst());
            if (missing > 0) {
                to.append(BlankSequence.create(missing));
            }
        } else {
            for (int i = 0; i < this.width; ++i) {
                to.append(' ');
            }
        }
        ++this.index;
        if (style != null) {
            to.leaveStyle();
        }
    }
}

