/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.LineRenderer;
import com.taobao.text.ui.LabelElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public abstract class Renderer<E> {
    private static final Renderer<?>[] renderables;
    public static Renderer<Object> ANY;

    public static <I> Renderer<? super I> getRenderable(Class<I> itemType) {
        for (Renderer<?> formatter : renderables) {
            try {
                if (!formatter.getType().isAssignableFrom(itemType)) continue;
                return formatter;
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract Class<E> getType();

    public abstract LineRenderer renderer(Iterator<E> var1);

    static {
        ArrayList<Renderer> tmp = new ArrayList<Renderer>();
        Iterator<Renderer> i = ServiceLoader.load(Renderer.class).iterator();
        while (i.hasNext()) {
            try {
                Renderer renderable = i.next();
                tmp.add(renderable);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        renderables = tmp.toArray(new Renderer[tmp.size()]);
        ANY = new Renderer<Object>(){

            @Override
            public Class<Object> getType() {
                return Object.class;
            }

            @Override
            public LineRenderer renderer(Iterator<Object> stream) {
                StringBuilder sb = new StringBuilder();
                while (stream.hasNext()) {
                    Object next = stream.next();
                    if (next instanceof CharSequence) {
                        sb.append((CharSequence)next);
                        continue;
                    }
                    sb.append(next);
                }
                return new LabelElement(sb.toString()).renderer();
            }
        };
    }
}

