/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.queue;

import com.stoyanr.evictor.EvictionQueue;
import com.stoyanr.evictor.map.EvictibleEntry;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class NavigableMapEvictionQueue<K, V>
implements EvictionQueue<K, V> {
    private final ConcurrentNavigableMap<Long, EvictibleEntry<K, V>> map;

    public NavigableMapEvictionQueue() {
        this(new ConcurrentSkipListMap<Long, EvictibleEntry<K, V>>());
    }

    public NavigableMapEvictionQueue(ConcurrentNavigableMap<Long, EvictibleEntry<K, V>> map) {
        if (map == null) {
            throw new NullPointerException("Map instnace cannot be null");
        }
        this.map = map;
    }

    @Override
    public boolean hasEntries() {
        return !this.map.isEmpty();
    }

    @Override
    public long getNextEvictionTime() {
        try {
            return !this.map.isEmpty() ? (Long)this.map.firstKey() : 0L;
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    @Override
    public void putEntry(EvictibleEntry<K, V> e) {
        this.map.put(e.getEvictionTime(), e);
    }

    @Override
    public void removeEntry(EvictibleEntry<K, V> e) {
        this.map.remove(e.getEvictionTime(), e);
    }

    @Override
    public boolean evictEntries() {
        boolean result = false;
        SortedMap head = this.map.headMap((Object)System.nanoTime());
        if (!head.isEmpty()) {
            for (EvictibleEntry e : head.values()) {
                e.evict(false);
            }
            head.clear();
            result = true;
        }
        return result;
    }
}

