/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001c\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002;<B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u0006J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006J\u0006\u0010 \u001a\u00020\u0006J\u0013\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010#\u001a\u00020\u0013H\u0016J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010$\u001a\u00020\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\u0006\u0010&\u001a\u00020\u0013J(\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000f2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000f2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010*\u001a\u0004\u0018\u00010\u0006J\u0010\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020\u0006J\u000e\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0013J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000600J\u0010\u00101\u001a\u0004\u0018\u00010\u00062\u0006\u0010.\u001a\u00020\u0013J\u0016\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000f2\u0006\u0010,\u001a\u00020\u0006J\u0006\u00103\u001a\u00020\u0013J\u0006\u00104\u001a\u00020\u0006J\u0010\u00105\u001a\u0004\u0018\u00010\u00002\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0006J\b\u00106\u001a\u00020\u0006H\u0016J\b\u00107\u001a\u0004\u0018\u00010\u0006J\u0006\u00108\u001a\u000209J\u0006\u0010\u0019\u001a\u00020:J\u0006\u0010\u001a\u001a\u00020\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lokhttp3/HttpUrl;", "", "builder", "Lokhttp3/HttpUrl$Builder;", "(Lokhttp3/HttpUrl$Builder;)V", "fragment", "", "host", "getHost$okhttp", "()Ljava/lang/String;", "isHttps", "", "()Z", "password", "pathSegments", "", "pathSegments$annotations", "()V", "port", "", "getPort$okhttp", "()I", "queryNamesAndValues", "scheme", "getScheme$okhttp", "url", "username", "encodedFragment", "encodedPassword", "encodedPath", "encodedPathSegments", "encodedQuery", "encodedUsername", "equals", "other", "hashCode", "newBuilder", "link", "pathSize", "percentDecode", "list", "plusIsSpace", "query", "queryParameter", "name", "queryParameterName", "index", "queryParameterNames", "", "queryParameterValue", "queryParameterValues", "querySize", "redact", "resolve", "toString", "topPrivateDomain", "uri", "Ljava/net/URI;", "Ljava/net/URL;", "Builder", "Companion", "okhttp"})
public final class HttpUrl {
    @NotNull
    private final String scheme;
    private final String username;
    private final String password;
    @NotNull
    private final String host;
    private final int port;
    private final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    private final String fragment;
    private final String url;
    private final boolean isHttps;
    private static final char[] HEX_DIGITS;
    @NotNull
    public static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    @NotNull
    public static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    @NotNull
    public static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    @NotNull
    public static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    @NotNull
    public static final String QUERY_ENCODE_SET = " \"'<>#";
    @NotNull
    public static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    @NotNull
    public static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    @NotNull
    public static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    @NotNull
    public static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    @NotNull
    public static final String FRAGMENT_ENCODE_SET = "";
    @NotNull
    public static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    public static final Companion Companion;

    @NotNull
    public final String getScheme$okhttp() {
        return this.scheme;
    }

    @NotNull
    public final String getHost$okhttp() {
        return this.host;
    }

    public final int getPort$okhttp() {
        return this.port;
    }

    private static /* synthetic */ void pathSegments$annotations() {
    }

    public final boolean isHttps() {
        return this.isHttps;
    }

    @NotNull
    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final URI uri() {
        String uri = this.newBuilder().reencodeForUri$okhttp().toString();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            try {
                CharSequence charSequence = uri;
                Regex regex = new Regex("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]");
                String string = FRAGMENT_ENCODE_SET;
                boolean bl = false;
                String stripped = regex.replace(charSequence, string);
                URI uRI = URI.create(stripped);
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(stripped)");
                return uRI;
            }
            catch (Exception e1) {
                throw (Throwable)new RuntimeException(e);
            }
        }
    }

    @NotNull
    public final String scheme() {
        return this.scheme;
    }

    @NotNull
    public final String encodedUsername() {
        CharSequence charSequence = this.username;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return FRAGMENT_ENCODE_SET;
        }
        int usernameStart = this.scheme.length() + 3;
        int usernameEnd = Util.delimiterOffset(this.url, usernameStart, this.url.length(), ":@");
        String string = this.url;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(usernameStart, usernameEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String username() {
        return this.username;
    }

    @NotNull
    public final String encodedPassword() {
        CharSequence charSequence = this.password;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return FRAGMENT_ENCODE_SET;
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)this.url, (char)':', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)this.url, (char)'@', (int)0, (boolean)false, (int)6, null);
        String string = this.url;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(passwordStart, passwordEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String password() {
        return this.password;
    }

    @NotNull
    public final String host() {
        return this.host;
    }

    public final int port() {
        return this.port;
    }

    public final int pathSize() {
        return this.pathSegments.size();
    }

    @NotNull
    public final String encodedPath() {
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = Util.delimiterOffset(this.url, pathStart, this.url.length(), "?#");
        String string = this.url;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(pathStart, pathEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final List<String> encodedPathSegments() {
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = Util.delimiterOffset(this.url, pathStart, this.url.length(), "?#");
        ArrayList<String> result = new ArrayList<String>();
        int i = pathStart;
        while (i < pathEnd) {
            String string;
            int segmentEnd = Util.delimiterOffset(this.url, ++i, pathEnd, '/');
            String string2 = this.url;
            ArrayList<String> arrayList = result;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(i, segmentEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            arrayList.add(string);
            i = segmentEnd;
        }
        return result;
    }

    @NotNull
    public final List<String> pathSegments() {
        return this.pathSegments;
    }

    @Nullable
    public final String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int queryStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
        int queryEnd = Util.delimiterOffset(this.url, queryStart, this.url.length(), '#');
        String string = this.url;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(queryStart, queryEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @Nullable
    public final String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Companion.namesAndValuesToQueryString$okhttp(result, this.queryNamesAndValues);
        return result.toString();
    }

    public final int querySize() {
        return this.queryNamesAndValues != null ? this.queryNamesAndValues.size() / 2 : 0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String queryParameter(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (this.queryNamesAndValues == null) {
            return null;
        }
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.queryNamesAndValues.size())), (int)2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                if (Intrinsics.areEqual((Object)name, (Object)this.queryNamesAndValues.get((int)i))) {
                    return this.queryNamesAndValues.get((int)(i + true));
                }
                if (i == n2) break;
                n = i + n3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return SetsKt.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.queryNamesAndValues.size())), (int)2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                String string = this.queryNamesAndValues.get((int)i);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                result.add(string);
                if (i == n2) break;
                n = i + n3;
            }
        }
        Set<String> set = Collections.unmodifiableSet((Set)result);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(result)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> queryParameterValues(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (this.queryNamesAndValues == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.queryNamesAndValues.size())), (int)2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                if (Intrinsics.areEqual((Object)name, (Object)this.queryNamesAndValues.get((int)i))) {
                    result.add(this.queryNamesAndValues.get((int)(i + true)));
                }
                if (i == n2) break;
                n = i + n3;
            }
        }
        List<String> list = Collections.unmodifiableList((List)result);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(result)");
        return list;
    }

    @NotNull
    public final String queryParameterName(int index) {
        if (this.queryNamesAndValues == null) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        String string = this.queryNamesAndValues.get(index * 2);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public final String queryParameterValue(int index) {
        if (this.queryNamesAndValues == null) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(index * 2 + 1);
    }

    @Nullable
    public final String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int fragmentStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
        String string = this.url;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(fragmentStart);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        return string3;
    }

    @Nullable
    public final String fragment() {
        return this.fragment;
    }

    @NotNull
    public final String redact() {
        Builder builder = this.newBuilder("/...");
        if (builder == null) {
            Intrinsics.throwNpe();
        }
        return builder.username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public final HttpUrl resolve(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Builder builder = this.newBuilder(link);
        return builder != null ? builder.build() : null;
    }

    @NotNull
    public final Builder newBuilder() {
        Builder result = new Builder();
        result.setScheme$okhttp(this.scheme);
        result.setEncodedUsername$okhttp(this.encodedUsername());
        result.setEncodedPassword$okhttp(this.encodedPassword());
        result.setHost$okhttp(this.host);
        result.setPort$okhttp(this.port != Companion.defaultPort(this.scheme) ? this.port : -1);
        result.getEncodedPathSegments$okhttp().clear();
        result.getEncodedPathSegments$okhttp().addAll((Collection<String>)this.encodedPathSegments());
        result.encodedQuery(this.encodedQuery());
        result.setEncodedFragment$okhttp(this.encodedFragment());
        return result;
    }

    @Nullable
    public final Builder newBuilder(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        try {
            return new Builder().parse$okhttp(this, link);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HttpUrl && Intrinsics.areEqual((Object)((HttpUrl)other).url, (Object)this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    @NotNull
    public String toString() {
        return this.url;
    }

    @Nullable
    public final String topPrivateDomain() {
        if (Util.verifyAsIpAddress(this.host)) {
            return null;
        }
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> percentDecode(List<String> list, boolean plusIsSpace) {
        int size = list.size();
        ArrayList<String> result = new ArrayList<String>(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            String s = list.get((int)i);
            result.add(s != null ? Companion.percentDecode$okhttp(s, plusIsSpace) : null);
            ++i;
        }
        List<String> list2 = Collections.unmodifiableList((List)result);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.unmodifiableList(result)");
        return list2;
    }

    public HttpUrl(@NotNull Builder builder) {
        Object object;
        List<String> list;
        Object object2;
        Object it;
        boolean bl;
        boolean bl2;
        HttpUrl httpUrl;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        String string = builder.getScheme$okhttp();
        if (string == null) {
            throw (Throwable)new IllegalStateException("scheme == null");
        }
        this.scheme = string;
        this.username = Companion.percentDecode$okhttp(builder.getEncodedUsername$okhttp(), false);
        this.password = Companion.percentDecode$okhttp(builder.getEncodedPassword$okhttp(), false);
        String string2 = builder.getHost$okhttp();
        if (string2 == null) {
            throw (Throwable)new IllegalStateException("host == null");
        }
        this.host = string2;
        this.port = builder.effectivePort$okhttp();
        List<String> list2 = this.percentDecode(builder.getEncodedPathSegments$okhttp(), false);
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        }
        this.pathSegments = list2;
        HttpUrl httpUrl2 = this;
        List<String> list3 = builder.getEncodedQueryNamesAndValues$okhttp();
        if (list3 != null) {
            object3 = list3;
            httpUrl = httpUrl2;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl3 = false;
            object2 = this.percentDecode((List<String>)it, true);
            httpUrl2 = httpUrl;
            list = object2;
        } else {
            list = null;
        }
        httpUrl2.queryNamesAndValues = list;
        HttpUrl httpUrl3 = this;
        String string3 = builder.getEncodedFragment$okhttp();
        if (string3 != null) {
            object3 = string3;
            httpUrl = httpUrl3;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl4 = false;
            object2 = Companion.percentDecode$okhttp((String)it, false);
            httpUrl3 = httpUrl;
            object = object2;
        } else {
            object = null;
        }
        httpUrl3.fragment = object;
        this.url = builder.toString();
        this.isHttps = Intrinsics.areEqual((Object)this.scheme, (Object)"https");
    }

    static {
        Companion = new Companion(null);
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    @JvmStatic
    public static final int defaultPort(@NotNull String scheme) {
        return Companion.defaultPort(scheme);
    }

    @JvmStatic
    public static final void pathSegmentsToString$okhttp(@NotNull StringBuilder out, @NotNull List<String> pathSegments) {
        Companion.pathSegmentsToString$okhttp(out, pathSegments);
    }

    @JvmStatic
    public static final void namesAndValuesToQueryString$okhttp(@NotNull StringBuilder out, @NotNull List<String> namesAndValues) {
        Companion.namesAndValuesToQueryString$okhttp(out, namesAndValues);
    }

    @JvmStatic
    @NotNull
    public static final List<String> queryStringToNamesAndValues$okhttp(@NotNull String encodedQuery) {
        return Companion.queryStringToNamesAndValues$okhttp(encodedQuery);
    }

    @JvmStatic
    @Nullable
    public static final HttpUrl parse(@NotNull String url) {
        return Companion.parse(url);
    }

    @JvmStatic
    @NotNull
    public static final HttpUrl get(@NotNull String url) {
        return Companion.get(url);
    }

    @JvmStatic
    @Nullable
    public static final HttpUrl get(@NotNull URL url) {
        return Companion.get(url);
    }

    @JvmStatic
    @Nullable
    public static final HttpUrl get(@NotNull URI uri) {
        return Companion.get(uri);
    }

    @JvmStatic
    @NotNull
    public static final String percentDecode$okhttp(@NotNull String encoded, boolean plusIsSpace) {
        return Companion.percentDecode$okhttp(encoded, plusIsSpace);
    }

    @JvmStatic
    @NotNull
    public static final String percentDecode$okhttp(@NotNull String encoded, int pos, int limit, boolean plusIsSpace) {
        return Companion.percentDecode$okhttp(encoded, pos, limit, plusIsSpace);
    }

    @JvmStatic
    public static final void percentDecode$okhttp(@NotNull Buffer out, @NotNull String encoded, int pos, int limit, boolean plusIsSpace) {
        Companion.percentDecode$okhttp(out, encoded, pos, limit, plusIsSpace);
    }

    @JvmStatic
    public static final boolean percentEncoded$okhttp(@NotNull String encoded, int pos, int limit) {
        return Companion.percentEncoded$okhttp(encoded, pos, limit);
    }

    @JvmStatic
    @NotNull
    public static final String canonicalize$okhttp(@NotNull String input, int pos, int limit, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, @Nullable Charset charset) {
        return Companion.canonicalize$okhttp(input, pos, limit, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
    }

    @JvmStatic
    public static final void canonicalize$okhttp(@NotNull Buffer out, @NotNull String input, int pos, int limit, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, @Nullable Charset charset) {
        Companion.canonicalize$okhttp(out, input, pos, limit, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
    }

    @JvmStatic
    @NotNull
    public static final String canonicalize$okhttp(@NotNull String input, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, @Nullable Charset charset) {
        return Companion.canonicalize$okhttp(input, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
    }

    @JvmStatic
    @NotNull
    public static final String canonicalize$okhttp(@NotNull String input, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly) {
        return Companion.canonicalize$okhttp(input, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0017\u0018\u0000 W2\u00020\u0001:\u0001WB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004J\u0018\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004J\u0006\u00102\u001a\u000203J\r\u00104\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b5J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004J\u000e\u00106\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0004J\u0010\u00107\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u00108\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\u0004H\u0002J\u0010\u0010;\u001a\u00020.2\u0006\u0010:\u001a\u00020\u0004H\u0002J\u001f\u0010<\u001a\u00020\u00002\b\u0010=\u001a\u0004\u0018\u0001032\u0006\u0010:\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b>J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u0004J\b\u0010@\u001a\u00020AH\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010B\u001a\u00020A2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020.2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010F\u001a\u00020\u00002\b\u0010F\u001a\u0004\u0018\u00010\u0004J\r\u0010G\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020\u0004H\u0002J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010L\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0004J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u001bJ \u0010O\u001a\u00020A2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\u001bH\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0004J\u0016\u0010Q\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0004J\u0018\u0010R\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u0016\u0010S\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0004J\u0018\u0010T\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004J\b\u0010U\u001a\u00020\u0004H\u0016J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\bR\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\b\u00a8\u0006X"}, d2={"Lokhttp3/HttpUrl$Builder;", "", "()V", "encodedFragment", "", "getEncodedFragment$okhttp", "()Ljava/lang/String;", "setEncodedFragment$okhttp", "(Ljava/lang/String;)V", "encodedPassword", "getEncodedPassword$okhttp", "setEncodedPassword$okhttp", "encodedPathSegments", "", "getEncodedPathSegments$okhttp", "()Ljava/util/List;", "encodedQueryNamesAndValues", "getEncodedQueryNamesAndValues$okhttp", "setEncodedQueryNamesAndValues$okhttp", "(Ljava/util/List;)V", "encodedUsername", "getEncodedUsername$okhttp", "setEncodedUsername$okhttp", "host", "getHost$okhttp", "setHost$okhttp", "port", "", "getPort$okhttp", "()I", "setPort$okhttp", "(I)V", "scheme", "getScheme$okhttp", "setScheme$okhttp", "addEncodedPathSegment", "encodedPathSegment", "addEncodedPathSegments", "addEncodedQueryParameter", "encodedName", "encodedValue", "addPathSegment", "pathSegment", "addPathSegments", "pathSegments", "alreadyEncoded", "", "addQueryParameter", "name", "value", "build", "Lokhttp3/HttpUrl;", "effectivePort", "effectivePort$okhttp", "encodedPath", "encodedQuery", "fragment", "isDot", "input", "isDotDot", "parse", "base", "parse$okhttp", "password", "pop", "", "push", "pos", "limit", "addTrailingSlash", "query", "reencodeForUri", "reencodeForUri$okhttp", "removeAllCanonicalQueryParameters", "canonicalName", "removeAllEncodedQueryParameters", "removeAllQueryParameters", "removePathSegment", "index", "resolvePath", "startPos", "setEncodedPathSegment", "setEncodedQueryParameter", "setPathSegment", "setQueryParameter", "toString", "username", "Companion", "okhttp"})
    public static final class Builder {
        @Nullable
        private String scheme;
        @NotNull
        private String encodedUsername = "";
        @NotNull
        private String encodedPassword = "";
        @Nullable
        private String host;
        private int port = -1;
        @NotNull
        private final List<String> encodedPathSegments;
        @Nullable
        private List<String> encodedQueryNamesAndValues;
        @Nullable
        private String encodedFragment;
        @NotNull
        public static final String INVALID_HOST = "Invalid URL host";
        public static final Companion Companion = new Companion(null);

        @Nullable
        public final String getScheme$okhttp() {
            return this.scheme;
        }

        public final void setScheme$okhttp(@Nullable String string) {
            this.scheme = string;
        }

        @NotNull
        public final String getEncodedUsername$okhttp() {
            return this.encodedUsername;
        }

        public final void setEncodedUsername$okhttp(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.encodedUsername = string;
        }

        @NotNull
        public final String getEncodedPassword$okhttp() {
            return this.encodedPassword;
        }

        public final void setEncodedPassword$okhttp(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.encodedPassword = string;
        }

        @Nullable
        public final String getHost$okhttp() {
            return this.host;
        }

        public final void setHost$okhttp(@Nullable String string) {
            this.host = string;
        }

        public final int getPort$okhttp() {
            return this.port;
        }

        public final void setPort$okhttp(int n) {
            this.port = n;
        }

        @NotNull
        public final List<String> getEncodedPathSegments$okhttp() {
            return this.encodedPathSegments;
        }

        @Nullable
        public final List<String> getEncodedQueryNamesAndValues$okhttp() {
            return this.encodedQueryNamesAndValues;
        }

        public final void setEncodedQueryNamesAndValues$okhttp(@Nullable List<String> list) {
            this.encodedQueryNamesAndValues = list;
        }

        @Nullable
        public final String getEncodedFragment$okhttp() {
            return this.encodedFragment;
        }

        public final void setEncodedFragment$okhttp(@Nullable String string) {
            this.encodedFragment = string;
        }

        @NotNull
        public final Builder scheme(@NotNull String scheme) {
            Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
            if (StringsKt.equals((String)scheme, (String)"http", (boolean)true)) {
                this.scheme = "http";
            } else if (StringsKt.equals((String)scheme, (String)"https", (boolean)true)) {
                this.scheme = "https";
            } else {
                throw (Throwable)new IllegalArgumentException("unexpected scheme: " + scheme);
            }
            return this;
        }

        @NotNull
        public final Builder username(@NotNull String username) {
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            this.encodedUsername = Companion.canonicalize$okhttp(username, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        @NotNull
        public final Builder encodedUsername(@NotNull String encodedUsername) {
            Intrinsics.checkParameterIsNotNull((Object)encodedUsername, (String)"encodedUsername");
            this.encodedUsername = Companion.canonicalize$okhttp(encodedUsername, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        @NotNull
        public final Builder password(@NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            this.encodedPassword = Companion.canonicalize$okhttp(password, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        @NotNull
        public final Builder encodedPassword(@NotNull String encodedPassword) {
            Intrinsics.checkParameterIsNotNull((Object)encodedPassword, (String)"encodedPassword");
            this.encodedPassword = Companion.canonicalize$okhttp(encodedPassword, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        @NotNull
        public final Builder host(@NotNull String host) {
            String encoded;
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            String string = Builder.Companion.canonicalizeHost(host, 0, host.length());
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("unexpected host: " + host);
            }
            this.host = encoded = string;
            return this;
        }

        @NotNull
        public final Builder port(int port) {
            if (port <= 0 || port > 65535) {
                throw (Throwable)new IllegalArgumentException("unexpected port: " + port);
            }
            this.port = port;
            return this;
        }

        public final int effectivePort$okhttp() {
            int n;
            if (this.port != -1) {
                n = this.port;
            } else {
                String string = this.scheme;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                n = Companion.defaultPort(string);
            }
            return n;
        }

        @NotNull
        public final Builder addPathSegment(@NotNull String pathSegment) {
            Intrinsics.checkParameterIsNotNull((Object)pathSegment, (String)"pathSegment");
            this.push(pathSegment, 0, pathSegment.length(), false, false);
            return this;
        }

        @NotNull
        public final Builder addPathSegments(@NotNull String pathSegments) {
            Intrinsics.checkParameterIsNotNull((Object)pathSegments, (String)"pathSegments");
            return this.addPathSegments(pathSegments, false);
        }

        @NotNull
        public final Builder addEncodedPathSegment(@NotNull String encodedPathSegment) {
            Intrinsics.checkParameterIsNotNull((Object)encodedPathSegment, (String)"encodedPathSegment");
            this.push(encodedPathSegment, 0, encodedPathSegment.length(), false, true);
            return this;
        }

        @NotNull
        public final Builder addEncodedPathSegments(@NotNull String encodedPathSegments) {
            Intrinsics.checkParameterIsNotNull((Object)encodedPathSegments, (String)"encodedPathSegments");
            return this.addPathSegments(encodedPathSegments, true);
        }

        private final Builder addPathSegments(String pathSegments, boolean alreadyEncoded) {
            int segmentEnd;
            int offset = 0;
            do {
                boolean addTrailingSlash = (segmentEnd = Util.delimiterOffset(pathSegments, offset, pathSegments.length(), "/\\")) < pathSegments.length();
                this.push(pathSegments, offset, segmentEnd, addTrailingSlash, alreadyEncoded);
            } while ((offset = segmentEnd + 1) <= pathSegments.length());
            return this;
        }

        @NotNull
        public final Builder setPathSegment(int index, @NotNull String pathSegment) {
            Intrinsics.checkParameterIsNotNull((Object)pathSegment, (String)"pathSegment");
            String canonicalPathSegment = Companion.canonicalize$okhttp(pathSegment, 0, pathSegment.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, false, false, false, true, null);
            if (this.isDot(canonicalPathSegment) || this.isDotDot(canonicalPathSegment)) {
                throw (Throwable)new IllegalArgumentException("unexpected path segment: " + pathSegment);
            }
            this.encodedPathSegments.set(index, canonicalPathSegment);
            return this;
        }

        @NotNull
        public final Builder setEncodedPathSegment(int index, @NotNull String encodedPathSegment) {
            Intrinsics.checkParameterIsNotNull((Object)encodedPathSegment, (String)"encodedPathSegment");
            String canonicalPathSegment = Companion.canonicalize$okhttp(encodedPathSegment, 0, encodedPathSegment.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, true, false, false, true, null);
            this.encodedPathSegments.set(index, canonicalPathSegment);
            if (this.isDot(canonicalPathSegment) || this.isDotDot(canonicalPathSegment)) {
                throw (Throwable)new IllegalArgumentException("unexpected path segment: " + encodedPathSegment);
            }
            return this;
        }

        @NotNull
        public final Builder removePathSegment(int index) {
            this.encodedPathSegments.remove(index);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        @NotNull
        public final Builder encodedPath(@NotNull String encodedPath) {
            Intrinsics.checkParameterIsNotNull((Object)encodedPath, (String)"encodedPath");
            if (!StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
                throw (Throwable)new IllegalArgumentException("unexpected encodedPath: " + encodedPath);
            }
            this.resolvePath(encodedPath, 0, encodedPath.length());
            return this;
        }

        @NotNull
        public final Builder query(@Nullable String query) {
            this.encodedQueryNamesAndValues = query != null ? Companion.queryStringToNamesAndValues$okhttp(Companion.canonicalize$okhttp(query, HttpUrl.QUERY_ENCODE_SET, false, false, true, true)) : null;
            return this;
        }

        @NotNull
        public final Builder encodedQuery(@Nullable String encodedQuery) {
            this.encodedQueryNamesAndValues = encodedQuery != null ? Companion.queryStringToNamesAndValues$okhttp(Companion.canonicalize$okhttp(encodedQuery, HttpUrl.QUERY_ENCODE_SET, true, false, true, true)) : null;
            return this;
        }

        @NotNull
        public final Builder addQueryParameter(@NotNull String name, @Nullable String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList();
            }
            List<String> list = this.encodedQueryNamesAndValues;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(Companion.canonicalize$okhttp(name, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
            List<String> list2 = this.encodedQueryNamesAndValues;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add(value != null ? Companion.canonicalize$okhttp(value, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null);
            return this;
        }

        @NotNull
        public final Builder addEncodedQueryParameter(@NotNull String encodedName, @Nullable String encodedValue) {
            Intrinsics.checkParameterIsNotNull((Object)encodedName, (String)"encodedName");
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList();
            }
            List<String> list = this.encodedQueryNamesAndValues;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(Companion.canonicalize$okhttp(encodedName, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            List<String> list2 = this.encodedQueryNamesAndValues;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add(encodedValue != null ? Companion.canonicalize$okhttp(encodedValue, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true) : null);
            return this;
        }

        @NotNull
        public final Builder setQueryParameter(@NotNull String name, @Nullable String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.removeAllQueryParameters(name);
            this.addQueryParameter(name, value);
            return this;
        }

        @NotNull
        public final Builder setEncodedQueryParameter(@NotNull String encodedName, @Nullable String encodedValue) {
            Intrinsics.checkParameterIsNotNull((Object)encodedName, (String)"encodedName");
            this.removeAllEncodedQueryParameters(encodedName);
            this.addEncodedQueryParameter(encodedName, encodedValue);
            return this;
        }

        @NotNull
        public final Builder removeAllQueryParameters(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            String nameToRemove = Companion.canonicalize$okhttp(name, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
            this.removeAllCanonicalQueryParameters(nameToRemove);
            return this;
        }

        @NotNull
        public final Builder removeAllEncodedQueryParameters(@NotNull String encodedName) {
            Intrinsics.checkParameterIsNotNull((Object)encodedName, (String)"encodedName");
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(Companion.canonicalize$okhttp(encodedName, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            return this;
        }

        private final void removeAllCanonicalQueryParameters(String canonicalName) {
            if (this.encodedQueryNamesAndValues == null) {
                Intrinsics.throwNpe();
            }
            for (int i = (v48422).size() - 2; i >= 0; i -= 2) {
                List<String> list = this.encodedQueryNamesAndValues;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!Intrinsics.areEqual((Object)canonicalName, (Object)list.get(i))) continue;
                List<String> list2 = this.encodedQueryNamesAndValues;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                list2.remove(i + 1);
                List<String> list3 = this.encodedQueryNamesAndValues;
                if (list3 == null) {
                    Intrinsics.throwNpe();
                }
                list3.remove(i);
                List<String> list4 = this.encodedQueryNamesAndValues;
                if (list4 == null) {
                    Intrinsics.throwNpe();
                }
                if (!list4.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        @NotNull
        public final Builder fragment(@Nullable String fragment) {
            this.encodedFragment = fragment != null ? Companion.canonicalize$okhttp(fragment, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            return this;
        }

        @NotNull
        public final Builder encodedFragment(@Nullable String encodedFragment) {
            this.encodedFragment = encodedFragment != null ? Companion.canonicalize$okhttp(encodedFragment, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            return this;
        }

        @NotNull
        public final Builder reencodeForUri$okhttp() {
            int i;
            int n = 0;
            int n2 = this.encodedPathSegments.size();
            while (n < n2) {
                String pathSegment = this.encodedPathSegments.get(i);
                this.encodedPathSegments.set(i, Companion.canonicalize$okhttp(pathSegment, HttpUrl.PATH_SEGMENT_ENCODE_SET_URI, true, true, false, true));
                ++i;
            }
            if (this.encodedQueryNamesAndValues != null) {
                i = 0;
                List<String> list = this.encodedQueryNamesAndValues;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                n2 = list.size();
                while (i < n2) {
                    String component;
                    List<String> list2 = this.encodedQueryNamesAndValues;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((component = list2.get(i)) != null) {
                        List<String> list3 = this.encodedQueryNamesAndValues;
                        if (list3 == null) {
                            Intrinsics.throwNpe();
                        }
                        list3.set(i, Companion.canonicalize$okhttp(component, HttpUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true, true));
                    }
                    ++i;
                }
            }
            if (this.encodedFragment != null) {
                String string = this.encodedFragment;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.encodedFragment = Companion.canonicalize$okhttp(string, HttpUrl.FRAGMENT_ENCODE_SET_URI, true, true, false, false);
            }
            return this;
        }

        @NotNull
        public final HttpUrl build() {
            return new HttpUrl(this);
        }

        @NotNull
        public String toString() {
            StringBuilder result;
            block19: {
                int effectivePort;
                block20: {
                    block18: {
                        boolean bl;
                        CharSequence charSequence;
                        block17: {
                            result = new StringBuilder();
                            if (this.scheme != null) {
                                result.append(this.scheme);
                                result.append("://");
                            } else {
                                result.append("//");
                            }
                            charSequence = this.encodedUsername;
                            bl = false;
                            if (charSequence.length() > 0) break block17;
                            charSequence = this.encodedPassword;
                            bl = false;
                            if (!(charSequence.length() > 0)) break block18;
                        }
                        result.append(this.encodedUsername);
                        charSequence = this.encodedPassword;
                        bl = false;
                        if (charSequence.length() > 0) {
                            result.append(':');
                            result.append(this.encodedPassword);
                        }
                        result.append('@');
                    }
                    if (this.host != null) {
                        String string = this.host;
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        if (StringsKt.indexOf$default((CharSequence)string, (char)':', (int)0, (boolean)false, (int)6, null) != -1) {
                            result.append('[');
                            result.append(this.host);
                            result.append(']');
                        } else {
                            result.append(this.host);
                        }
                    }
                    if (this.port == -1 && this.scheme == null) break block19;
                    effectivePort = this.effectivePort$okhttp();
                    if (this.scheme == null) break block20;
                    String string = this.scheme;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if (effectivePort == Companion.defaultPort(string)) break block19;
                }
                result.append(':');
                result.append(effectivePort);
            }
            Companion.pathSegmentsToString$okhttp(result, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                result.append('?');
                List<String> list = this.encodedQueryNamesAndValues;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                Companion.namesAndValuesToQueryString$okhttp(result, list);
            }
            if (this.encodedFragment != null) {
                result.append('#');
                result.append(this.encodedFragment);
            }
            String string = result.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Builder parse$okhttp(@Nullable HttpUrl base, @NotNull String input) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            int pos = Util.skipLeadingAsciiWhitespace(input, 0, input.length());
            int limit = Util.skipTrailingAsciiWhitespace(input, pos, input.length());
            int schemeDelimiterOffset = Builder.Companion.schemeDelimiterOffset(input, pos, limit);
            if (schemeDelimiterOffset != -1) {
                if (StringsKt.regionMatches((String)input, (int)pos, (String)"https:", (int)0, (int)6, (boolean)true)) {
                    this.scheme = "https";
                    pos += "https:".length();
                } else {
                    if (!StringsKt.regionMatches((String)input, (int)pos, (String)"http:", (int)0, (int)5, (boolean)true)) {
                        String string = input;
                        int n = 0;
                        StringBuilder stringBuilder = new StringBuilder().append("Expected URL scheme 'http' or 'https' but was '");
                        boolean bl = false;
                        String string2 = string.substring(n, schemeDelimiterOffset);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string3 = string2;
                        String string4 = stringBuilder.append(string3).append("'").toString();
                        throw (Throwable)new IllegalArgumentException(string4);
                    }
                    this.scheme = "http";
                    pos += "http:".length();
                }
            } else {
                if (base == null) {
                    throw (Throwable)new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no colon was found");
                }
                this.scheme = base.getScheme$okhttp();
            }
            boolean hasUsername = false;
            boolean hasPassword = false;
            int slashCount = Builder.Companion.slashCount(input, pos, limit);
            if (slashCount < 2 && base != null && !(Intrinsics.areEqual((Object)base.getScheme$okhttp(), (Object)this.scheme) ^ true)) {
                this.encodedUsername = base.encodedUsername();
                this.encodedPassword = base.encodedPassword();
                this.host = base.getHost$okhttp();
                this.port = base.getPort$okhttp();
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll((Collection<String>)base.encodedPathSegments());
                if (pos == limit || input.charAt(pos) == '#') {
                    this.encodedQuery(base.encodedQuery());
                }
            } else {
                pos += slashCount;
                block4: while (true) {
                    int componentDelimiterOffset;
                    int c = (componentDelimiterOffset = Util.delimiterOffset(input, pos, limit, "@/\\?#")) != limit ? (int)input.charAt(componentDelimiterOffset) : -1;
                    switch (c) {
                        case 64: {
                            if (!hasPassword) {
                                int passwordColonOffset = Util.delimiterOffset(input, pos, componentDelimiterOffset, ':');
                                String canonicalUsername = Companion.canonicalize$okhttp(input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                String string = this.encodedUsername = hasUsername ? this.encodedUsername + "%40" + canonicalUsername : canonicalUsername;
                                if (passwordColonOffset != componentDelimiterOffset) {
                                    hasPassword = true;
                                    this.encodedPassword = Companion.canonicalize$okhttp(input, passwordColonOffset + 1, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                hasUsername = true;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + Companion.canonicalize$okhttp(input, pos, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                            }
                            pos = componentDelimiterOffset + 1;
                            continue block4;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: {
                            boolean bl;
                            boolean bl2;
                            int portColonOffset = Builder.Companion.portColonOffset(input, pos, componentDelimiterOffset);
                            if (portColonOffset + 1 < componentDelimiterOffset) {
                                this.host = Builder.Companion.canonicalizeHost(input, pos, portColonOffset);
                                this.port = Builder.Companion.parsePort(input, portColonOffset + 1, componentDelimiterOffset);
                                boolean bl3 = this.port != -1;
                                bl2 = false;
                                bl = false;
                                if (!bl3) {
                                    boolean bl4 = false;
                                    String string = input;
                                    int n = portColonOffset + 1;
                                    int n2 = componentDelimiterOffset;
                                    StringBuilder stringBuilder = new StringBuilder().append("Invalid URL port: \"");
                                    boolean bl5 = false;
                                    String string5 = string.substring(n, n2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    String string6 = string5;
                                    String string7 = stringBuilder.append(string6).append('\"').toString();
                                    throw (Throwable)new IllegalArgumentException(string7.toString());
                                }
                            } else {
                                this.host = Builder.Companion.canonicalizeHost(input, pos, portColonOffset);
                                String string = this.scheme;
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.port = Companion.defaultPort(string);
                            }
                            boolean bl6 = this.host != null;
                            bl2 = false;
                            bl = false;
                            if (!bl6) {
                                boolean bl7 = false;
                                String string = input;
                                int n = pos;
                                int n3 = portColonOffset;
                                StringBuilder stringBuilder = new StringBuilder().append("Invalid URL host: \"");
                                boolean bl8 = false;
                                String string8 = string.substring(n, n3);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                String string9 = string8;
                                String string10 = stringBuilder.append(string9).append('\"').toString();
                                throw (Throwable)new IllegalArgumentException(string10.toString());
                            }
                            pos = componentDelimiterOffset;
                            break block4;
                        }
                        default: {
                            continue block4;
                        }
                    }
                    break;
                }
            }
            int pathDelimiterOffset = Util.delimiterOffset(input, pos, limit, "?#");
            this.resolvePath(input, pos, pathDelimiterOffset);
            pos = pathDelimiterOffset;
            if (pos < limit && input.charAt(pos) == '?') {
                int queryDelimiterOffset = Util.delimiterOffset(input, pos, limit, '#');
                this.encodedQueryNamesAndValues = Companion.queryStringToNamesAndValues$okhttp(Companion.canonicalize$okhttp(input, pos + 1, queryDelimiterOffset, HttpUrl.QUERY_ENCODE_SET, true, false, true, true, null));
                pos = queryDelimiterOffset;
            }
            if (pos < limit && input.charAt(pos) == '#') {
                this.encodedFragment = Companion.canonicalize$okhttp(input, pos + 1, limit, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
            }
            return this;
        }

        private final void resolvePath(String input, int startPos, int limit) {
            int pos = startPos;
            if (pos == limit) {
                return;
            }
            char c = input.charAt(pos);
            if (c == '/' || c == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
                ++pos;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            }
            int i = pos;
            while (i < limit) {
                int pathSegmentDelimiterOffset = Util.delimiterOffset(input, i, limit, "/\\");
                boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
                this.push(input, i, pathSegmentDelimiterOffset, segmentHasTrailingSlash, true);
                i = pathSegmentDelimiterOffset;
                if (!segmentHasTrailingSlash) continue;
                ++i;
            }
        }

        private final void push(String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
            String segment = Companion.canonicalize$okhttp(input, pos, limit, HttpUrl.PATH_SEGMENT_ENCODE_SET, alreadyEncoded, false, false, true, null);
            if (this.isDot(segment)) {
                return;
            }
            if (this.isDotDot(segment)) {
                this.pop();
                return;
            }
            CharSequence charSequence = this.encodedPathSegments.get(this.encodedPathSegments.size() - 1);
            boolean bl = false;
            if (charSequence.length() == 0) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, segment);
            } else {
                this.encodedPathSegments.add(segment);
            }
            if (addTrailingSlash) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private final boolean isDot(String input) {
            return Intrinsics.areEqual((Object)input, (Object)".") || StringsKt.equals((String)input, (String)"%2e", (boolean)true);
        }

        private final boolean isDotDot(String input) {
            return Intrinsics.areEqual((Object)input, (Object)"..") || StringsKt.equals((String)input, (String)"%2e.", (boolean)true) || StringsKt.equals((String)input, (String)".%2e", (boolean)true) || StringsKt.equals((String)input, (String)"%2e%2e", (boolean)true);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void pop() {
            String removed = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            Object object = removed;
            boolean bl = false;
            if (object.length() == 0) {
                object = this.encodedPathSegments;
                bl = false;
                if (!object.isEmpty()) {
                    this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
                    return;
                }
            }
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        public Builder() {
            List list;
            Builder builder = this;
            boolean bl = false;
            builder.encodedPathSegments = list = (List)new ArrayList();
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        @JvmStatic
        private static final int schemeDelimiterOffset(String input, int pos, int limit) {
            return Builder.Companion.schemeDelimiterOffset(input, pos, limit);
        }

        @JvmStatic
        private static final int slashCount(String input, int pos, int limit) {
            return Builder.Companion.slashCount(input, pos, limit);
        }

        @JvmStatic
        private static final int portColonOffset(String input, int pos, int limit) {
            return Builder.Companion.portColonOffset(input, pos, limit);
        }

        @JvmStatic
        private static final String canonicalizeHost(String input, int pos, int limit) {
            return Builder.Companion.canonicalizeHost(input, pos, limit);
        }

        @JvmStatic
        private static final int parsePort(String input, int pos, int limit) {
            return Builder.Companion.parsePort(input, pos, limit);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0003J \u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0003J \u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0003J \u0010\f\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0003J \u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lokhttp3/HttpUrl$Builder$Companion;", "", "()V", "INVALID_HOST", "", "canonicalizeHost", "input", "pos", "", "limit", "parsePort", "portColonOffset", "schemeDelimiterOffset", "slashCount", "okhttp"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @JvmStatic
            private final int schemeDelimiterOffset(String input, int pos, int limit) {
                if (limit - pos < 2) {
                    return -1;
                }
                char c0 = input.charAt(pos);
                if (!(c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z')) {
                    return -1;
                }
                int n = pos + 1;
                int n2 = limit;
                while (n < n2) {
                    void i;
                    char c = input.charAt((int)i);
                    char c2 = c;
                    if ('a' > c2 || 'z' < c2) {
                        c2 = c;
                        if ('A' > c2 || 'Z' < c2) {
                            c2 = c;
                            if ('0' > c2 || '9' < c2) {
                                if (c != '+' && c != '-' && c != '.') {
                                    if (c == ':') {
                                        return (int)i;
                                    }
                                    return -1;
                                }
                            }
                        }
                    }
                    ++i;
                }
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            private final int slashCount(String input, int pos, int limit) {
                void i;
                char c;
                int slashCount = 0;
                int n = pos;
                int n2 = limit;
                while (n < n2 && ((c = input.charAt((int)i)) == '\\' || c == '/')) {
                    ++slashCount;
                    ++i;
                }
                return slashCount;
            }

            @JvmStatic
            private final int portColonOffset(String input, int pos, int limit) {
                block4: for (int i = pos; i < limit; ++i) {
                    switch (input.charAt(i)) {
                        case '[': {
                            while (++i < limit && input.charAt(i) != ']') {
                            }
                            continue block4;
                        }
                        case ':': {
                            return i;
                        }
                    }
                }
                return limit;
            }

            @JvmStatic
            private final String canonicalizeHost(String input, int pos, int limit) {
                String percentDecoded = HttpUrl.Companion.percentDecode$okhttp(input, pos, limit, false);
                return Util.canonicalizeHost(percentDecoded);
            }

            @JvmStatic
            private final int parsePort(String input, int pos, int limit) {
                try {
                    int i;
                    String portString = HttpUrl.Companion.canonicalize$okhttp(input, pos, limit, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null);
                    int n = i = Integer.parseInt(portString);
                    return 1 <= n && 65535 >= n ? i : -1;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JW\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0001\u00a2\u0006\u0002\b\u001fJ=\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001fJG\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0001\u00a2\u0006\u0002\b\u001fJ_\u0010\u0012\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0001\u00a2\u0006\u0002\b\u001fJ\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0004H\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0004H\u0007J)\u0010+\u001a\u00020 2\n\u0010!\u001a\u00060,j\u0002`-2\u000e\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040/H\u0001\u00a2\u0006\u0002\b0J\u0012\u00101\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020\u0004H\u0007J'\u00102\u001a\u00020 2\n\u0010!\u001a\u00060,j\u0002`-2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00040/H\u0001\u00a2\u0006\u0002\b4J\u001d\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b7J-\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b7J5\u00105\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00106\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b7J%\u00108\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b9J\u001d\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040;2\u0006\u0010<\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b=R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lokhttp3/HttpUrl$Companion;", "", "()V", "FORM_ENCODE_SET", "", "FRAGMENT_ENCODE_SET", "FRAGMENT_ENCODE_SET_URI", "HEX_DIGITS", "", "HEX_DIGITS$annotations", "PASSWORD_ENCODE_SET", "PATH_SEGMENT_ENCODE_SET", "PATH_SEGMENT_ENCODE_SET_URI", "QUERY_COMPONENT_ENCODE_SET", "QUERY_COMPONENT_ENCODE_SET_URI", "QUERY_COMPONENT_REENCODE_SET", "QUERY_ENCODE_SET", "USERNAME_ENCODE_SET", "canonicalize", "input", "pos", "", "limit", "encodeSet", "alreadyEncoded", "", "strict", "plusIsSpace", "asciiOnly", "charset", "Ljava/nio/charset/Charset;", "canonicalize$okhttp", "", "out", "Lokio/Buffer;", "defaultPort", "scheme", "get", "Lokhttp3/HttpUrl;", "uri", "Ljava/net/URI;", "url", "Ljava/net/URL;", "namesAndValuesToQueryString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "namesAndValues", "", "namesAndValuesToQueryString$okhttp", "parse", "pathSegmentsToString", "pathSegments", "pathSegmentsToString$okhttp", "percentDecode", "encoded", "percentDecode$okhttp", "percentEncoded", "percentEncoded$okhttp", "queryStringToNamesAndValues", "", "encodedQuery", "queryStringToNamesAndValues$okhttp", "okhttp"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void HEX_DIGITS$annotations() {
        }

        @JvmStatic
        public final int defaultPort(@NotNull String scheme) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
            switch (scheme) {
                case "http": {
                    n = 80;
                    break;
                }
                case "https": {
                    n = 443;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void pathSegmentsToString$okhttp(@NotNull StringBuilder out, @NotNull List<String> pathSegments) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull(pathSegments, (String)"pathSegments");
            int n = 0;
            int n2 = pathSegments.size();
            while (n < n2) {
                void i;
                out.append('/');
                out.append(pathSegments.get((int)i));
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void namesAndValuesToQueryString$okhttp(@NotNull StringBuilder out, @NotNull List<String> namesAndValues) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull(namesAndValues, (String)"namesAndValues");
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)namesAndValues.size())), (int)2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    String name = namesAndValues.get((int)i);
                    String value = namesAndValues.get((int)(i + true));
                    if (i > 0) {
                        out.append('&');
                    }
                    out.append(name);
                    if (value != null) {
                        out.append('=');
                        out.append(value);
                    }
                    if (i == n2) break;
                    n = i + n3;
                }
            }
        }

        @JvmStatic
        @NotNull
        public final List<String> queryStringToNamesAndValues$okhttp(@NotNull String encodedQuery) {
            Intrinsics.checkParameterIsNotNull((Object)encodedQuery, (String)"encodedQuery");
            boolean bl = false;
            List result = new ArrayList();
            int pos = 0;
            while (pos <= encodedQuery.length()) {
                String string;
                int n;
                List list;
                String string2;
                int equalsOffset;
                int ampersandOffset = StringsKt.indexOf$default((CharSequence)encodedQuery, (char)'&', (int)pos, (boolean)false, (int)4, null);
                if (ampersandOffset == -1) {
                    ampersandOffset = encodedQuery.length();
                }
                if ((equalsOffset = StringsKt.indexOf$default((CharSequence)encodedQuery, (char)'=', (int)pos, (boolean)false, (int)4, null)) == -1 || equalsOffset > ampersandOffset) {
                    string2 = encodedQuery;
                    list = result;
                    n = 0;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(pos, ampersandOffset), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    list.add(string);
                    result.add(null);
                } else {
                    string2 = encodedQuery;
                    list = result;
                    n = 0;
                    String string3 = string2.substring(pos, equalsOffset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = string3;
                    list.add(string);
                    string2 = encodedQuery;
                    n = equalsOffset + 1;
                    list = result;
                    boolean bl2 = false;
                    String string4 = string2.substring(n, ampersandOffset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = string4;
                    list.add(string);
                }
                pos = ampersandOffset + 1;
            }
            return result;
        }

        @JvmStatic
        @Nullable
        public final HttpUrl parse(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            try {
                return this.get(url);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }

        @JvmStatic
        @NotNull
        public final HttpUrl get(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            return new Builder().parse$okhttp(null, url).build();
        }

        @JvmStatic
        @Nullable
        public final HttpUrl get(@NotNull URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return this.parse(string);
        }

        @JvmStatic
        @Nullable
        public final HttpUrl get(@NotNull URI uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            String string = uri.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toString()");
            return this.parse(string);
        }

        @JvmStatic
        @NotNull
        public final String percentDecode$okhttp(@NotNull String encoded, boolean plusIsSpace) {
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            return this.percentDecode$okhttp(encoded, 0, encoded.length(), plusIsSpace);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String percentDecode$okhttp(@NotNull String encoded, int pos, int limit, boolean plusIsSpace) {
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            int n = pos;
            int n2 = limit;
            while (n < n2) {
                void i;
                char c = encoded.charAt((int)i);
                if (c == '%' || c == '+' && plusIsSpace) {
                    Buffer out = new Buffer();
                    out.writeUtf8(encoded, pos, (int)i);
                    this.percentDecode$okhttp(out, encoded, (int)i, limit, plusIsSpace);
                    return out.readUtf8();
                }
                ++i;
            }
            String string = encoded;
            n2 = 0;
            String string2 = string.substring(pos, limit);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string2;
        }

        @JvmStatic
        public final void percentDecode$okhttp(@NotNull Buffer out, @NotNull String encoded, int pos, int limit, boolean plusIsSpace) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            int codePoint = 0;
            int i = pos;
            while (i < limit) {
                String string = encoded;
                boolean bl = false;
                codePoint = string.codePointAt(i);
                if (codePoint == 37 && i + 2 < limit) {
                    int d1 = Util.decodeHexDigit(encoded.charAt(i + 1));
                    int d2 = Util.decodeHexDigit(encoded.charAt(i + 2));
                    if (d1 != -1 && d2 != -1) {
                        out.writeByte((d1 << 4) + d2);
                        i += 2;
                        i += Character.charCount(codePoint);
                        continue;
                    }
                } else if (codePoint == 43 && plusIsSpace) {
                    out.writeByte(32);
                    ++i;
                    continue;
                }
                out.writeUtf8CodePoint(codePoint);
                i += Character.charCount(codePoint);
            }
        }

        @JvmStatic
        public final boolean percentEncoded$okhttp(@NotNull String encoded, int pos, int limit) {
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            return pos + 2 < limit && encoded.charAt(pos) == '%' && Util.decodeHexDigit(encoded.charAt(pos + 1)) != -1 && Util.decodeHexDigit(encoded.charAt(pos + 2)) != -1;
        }

        @JvmStatic
        @NotNull
        public final String canonicalize$okhttp(@NotNull String input, int pos, int limit, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, @Nullable Charset charset) {
            boolean bl;
            String string;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)encodeSet, (String)"encodeSet");
            int codePoint = 0;
            for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
                string = input;
                bl = false;
                codePoint = string.codePointAt(i);
                if (!(codePoint < 32 || codePoint == 127 || codePoint >= 128 && asciiOnly || StringsKt.indexOf$default((CharSequence)encodeSet, (char)((char)codePoint), (int)0, (boolean)false, (int)6, null) != -1 || codePoint == 37 && (!alreadyEncoded || strict && !this.percentEncoded$okhttp(input, i, limit))) && (codePoint != 43 || !plusIsSpace)) continue;
                Buffer out = new Buffer();
                out.writeUtf8(input, pos, i);
                this.canonicalize$okhttp(out, input, i, limit, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
                return out.readUtf8();
            }
            string = input;
            bl = false;
            String string2 = string.substring(pos, limit);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string2;
        }

        @JvmStatic
        public final void canonicalize$okhttp(@NotNull Buffer out, @NotNull String input, int pos, int limit, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, @Nullable Charset charset) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)encodeSet, (String)"encodeSet");
            Buffer encodedCharBuffer = null;
            int codePoint = 0;
            for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
                String string = input;
                boolean bl = false;
                codePoint = string.codePointAt(i);
                if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
                if (codePoint == 43 && plusIsSpace) {
                    out.writeUtf8(alreadyEncoded ? "+" : "%2B");
                    continue;
                }
                if (codePoint < 32 || codePoint == 127 || codePoint >= 128 && asciiOnly || StringsKt.indexOf$default((CharSequence)encodeSet, (char)((char)codePoint), (int)0, (boolean)false, (int)6, null) != -1 || codePoint == 37 && (!alreadyEncoded || strict && !this.percentEncoded$okhttp(input, i, limit))) {
                    if (encodedCharBuffer == null) {
                        encodedCharBuffer = new Buffer();
                    }
                    if (charset == null || Intrinsics.areEqual((Object)charset, (Object)StandardCharsets.UTF_8)) {
                        encodedCharBuffer.writeUtf8CodePoint(codePoint);
                    } else {
                        encodedCharBuffer.writeString(input, i, i + Character.charCount(codePoint), charset);
                    }
                    while (!encodedCharBuffer.exhausted()) {
                        int b = encodedCharBuffer.readByte() & 0xFF;
                        out.writeByte(37);
                        out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                        out.writeByte((int)HEX_DIGITS[b & 0xF]);
                    }
                    continue;
                }
                out.writeUtf8CodePoint(codePoint);
            }
        }

        @JvmStatic
        @NotNull
        public final String canonicalize$okhttp(@NotNull String input, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, @Nullable Charset charset) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)encodeSet, (String)"encodeSet");
            return this.canonicalize$okhttp(input, 0, input.length(), encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
        }

        @JvmStatic
        @NotNull
        public final String canonicalize$okhttp(@NotNull String input, @NotNull String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)encodeSet, (String)"encodeSet");
            return this.canonicalize$okhttp(input, 0, input.length(), encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

