/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00030\u0007J\u0006\u0010\t\u001a\u00020\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/Challenge;", "", "scheme", "", "realm", "(Ljava/lang/String;Ljava/lang/String;)V", "authParams", "", "(Ljava/lang/String;Ljava/util/Map;)V", "charset", "Ljava/nio/charset/Charset;", "equals", "", "other", "hashCode", "", "toString", "withCharset", "okhttp"})
public final class Challenge {
    private final Map<String, String> authParams;
    private final String scheme;

    @NotNull
    public final Challenge withCharset(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        Map authParams = MapsKt.toMutableMap(this.authParams);
        String string = charset.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"charset.name()");
        authParams.put("charset", string);
        return new Challenge(this.scheme, authParams);
    }

    @NotNull
    public final String scheme() {
        return this.scheme;
    }

    @NotNull
    public final Map<String, String> authParams() {
        return this.authParams;
    }

    @Nullable
    public final String realm() {
        return this.authParams.get("realm");
    }

    @NotNull
    public final Charset charset() {
        String charset = this.authParams.get("charset");
        if (charset != null) {
            try {
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(charset)");
                return charset2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Charset charset3 = StandardCharsets.ISO_8859_1;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset3, (String)"ISO_8859_1");
        return charset3;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Challenge && Intrinsics.areEqual((Object)((Challenge)other).scheme, (Object)this.scheme) && Intrinsics.areEqual(((Challenge)other).authParams, this.authParams);
    }

    public int hashCode() {
        int result = 29;
        result = 31 * result + this.scheme.hashCode();
        result = 31 * result + ((Object)this.authParams).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }

    public Challenge(@NotNull String scheme, @NotNull Map<String, String> authParams) {
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        Intrinsics.checkParameterIsNotNull(authParams, (String)"authParams");
        this.scheme = scheme;
        boolean bl = false;
        Map newAuthParams = new LinkedHashMap();
        Map<String, String> map = authParams;
        boolean bl2 = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            boolean bl3 = false;
            String key = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            String value = entry2.getValue();
            if (key != null) {
                Locale locale;
                String string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"US");
                boolean bl4 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(locale);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            } else {
                string = null;
            }
            String newKey = string;
            newAuthParams.put(newKey, value);
        }
        Map map2 = Collections.unmodifiableMap(newAuthParams);
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"unmodifiableMap<String?, String>(newAuthParams)");
        this.authParams = map2;
    }

    public Challenge(@NotNull String scheme, @NotNull String realm) {
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        Intrinsics.checkParameterIsNotNull((Object)realm, (String)"realm");
        Map<String, String> map = Collections.singletonMap("realm", realm);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"singletonMap(\"realm\", realm)");
        this(scheme, map);
    }
}

