/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.internal.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016Bq\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lokhttp3/CacheControl;", "", "noCache", "", "noStore", "maxAgeSeconds", "", "sMaxAgeSeconds", "isPrivate", "isPublic", "mustRevalidate", "maxStaleSeconds", "minFreshSeconds", "onlyIfCached", "noTransform", "immutable", "headerValue", "", "(ZZIIZZZIIZZZLjava/lang/String;)V", "()Z", "toString", "Builder", "Companion", "okhttp"})
public final class CacheControl {
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    private final boolean noTransform;
    private final boolean immutable;
    private String headerValue;
    @JvmField
    @NotNull
    public static final CacheControl FORCE_NETWORK;
    @JvmField
    @NotNull
    public static final CacheControl FORCE_CACHE;
    public static final Companion Companion;

    public final boolean noCache() {
        return this.noCache;
    }

    public final boolean noStore() {
        return this.noStore;
    }

    public final int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public final int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public final boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public final int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public final int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public final boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public final boolean noTransform() {
        return this.noTransform;
    }

    public final boolean immutable() {
        return this.immutable;
    }

    @NotNull
    public String toString() {
        String result = this.headerValue;
        if (result == null) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl4 = false;
            if (this.noCache) {
                $this$buildString.append("no-cache, ");
            }
            if (this.noStore) {
                $this$buildString.append("no-store, ");
            }
            if (this.maxAgeSeconds != -1) {
                $this$buildString.append("max-age=").append(this.maxAgeSeconds).append(", ");
            }
            if (this.sMaxAgeSeconds != -1) {
                $this$buildString.append("s-maxage=").append(this.sMaxAgeSeconds).append(", ");
            }
            if (this.isPrivate) {
                $this$buildString.append("private, ");
            }
            if (this.isPublic) {
                $this$buildString.append("public, ");
            }
            if (this.mustRevalidate) {
                $this$buildString.append("must-revalidate, ");
            }
            if (this.maxStaleSeconds != -1) {
                $this$buildString.append("max-stale=").append(this.maxStaleSeconds).append(", ");
            }
            if (this.minFreshSeconds != -1) {
                $this$buildString.append("min-fresh=").append(this.minFreshSeconds).append(", ");
            }
            if (this.onlyIfCached) {
                $this$buildString.append("only-if-cached, ");
            }
            if (this.noTransform) {
                $this$buildString.append("no-transform, ");
            }
            if (this.immutable) {
                $this$buildString.append("immutable, ");
            }
            CharSequence charSequence = $this$buildString;
            boolean bl5 = false;
            if (charSequence.length() == 0) {
                return "";
            }
            $this$buildString.delete($this$buildString.length() - 2, $this$buildString.length());
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            this.headerValue = result = string;
        }
        return result;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    private CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue) {
        this.noCache = noCache;
        this.noStore = noStore;
        this.maxAgeSeconds = maxAgeSeconds;
        this.sMaxAgeSeconds = sMaxAgeSeconds;
        this.isPrivate = isPrivate;
        this.isPublic = isPublic;
        this.mustRevalidate = mustRevalidate;
        this.maxStaleSeconds = maxStaleSeconds;
        this.minFreshSeconds = minFreshSeconds;
        this.onlyIfCached = onlyIfCached;
        this.noTransform = noTransform;
        this.immutable = immutable;
        this.headerValue = headerValue;
    }

    static {
        Companion = new Companion(null);
        FORCE_NETWORK = new Builder().noCache().build();
        FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    }

    public /* synthetic */ CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue, DefaultConstructorMarker $constructor_marker) {
        this(noCache, noStore, maxAgeSeconds, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue);
    }

    @JvmStatic
    @NotNull
    public static final CacheControl parse(@NotNull Headers headers) {
        return Companion.parse(headers);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0003\u001a\u00020\u0000J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\t\u001a\u00020\u0000J\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0000J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/CacheControl$Builder;", "", "()V", "immutable", "", "maxAgeSeconds", "", "maxStaleSeconds", "minFreshSeconds", "noCache", "noStore", "noTransform", "onlyIfCached", "build", "Lokhttp3/CacheControl;", "maxAge", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "maxStale", "minFresh", "clampToInt", "", "okhttp"})
    public static final class Builder {
        private boolean noCache;
        private boolean noStore;
        private int maxAgeSeconds = -1;
        private int maxStaleSeconds = -1;
        private int minFreshSeconds = -1;
        private boolean onlyIfCached;
        private boolean noTransform;
        private boolean immutable;

        @NotNull
        public final Builder noCache() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.noCache = true;
            return builder;
        }

        @NotNull
        public final Builder noStore() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.noStore = true;
            return builder;
        }

        @NotNull
        public final Builder maxAge(int maxAge, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            if (maxAge < 0) {
                throw (Throwable)new IllegalArgumentException("maxAge < 0: " + maxAge);
            }
            long maxAgeSecondsLong = timeUnit.toSeconds(maxAge);
            $this$apply.maxAgeSeconds = $this$apply.clampToInt(maxAgeSecondsLong);
            return builder;
        }

        @NotNull
        public final Builder maxStale(int maxStale, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            if (maxStale < 0) {
                throw (Throwable)new IllegalArgumentException("maxStale < 0: " + maxStale);
            }
            long maxStaleSecondsLong = timeUnit.toSeconds(maxStale);
            $this$apply.maxStaleSeconds = $this$apply.clampToInt(maxStaleSecondsLong);
            return builder;
        }

        @NotNull
        public final Builder minFresh(int minFresh, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            if (minFresh < 0) {
                throw (Throwable)new IllegalArgumentException("minFresh < 0: " + minFresh);
            }
            long minFreshSecondsLong = timeUnit.toSeconds(minFresh);
            $this$apply.minFreshSeconds = $this$apply.clampToInt(minFreshSecondsLong);
            return builder;
        }

        @NotNull
        public final Builder onlyIfCached() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onlyIfCached = true;
            return builder;
        }

        @NotNull
        public final Builder noTransform() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.noTransform = true;
            return builder;
        }

        @NotNull
        public final Builder immutable() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.immutable = true;
            return builder;
        }

        private final int clampToInt(long $this$clampToInt) {
            return $this$clampToInt > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)$this$clampToInt;
        }

        @NotNull
        public final CacheControl build() {
            return new CacheControl(this.noCache, this.noStore, this.maxAgeSeconds, -1, false, false, false, this.maxStaleSeconds, this.minFreshSeconds, this.onlyIfCached, this.noTransform, this.immutable, null, null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lokhttp3/CacheControl$Companion;", "", "()V", "FORCE_CACHE", "Lokhttp3/CacheControl;", "FORCE_NETWORK", "parse", "headers", "Lokhttp3/Headers;", "indexOfElement", "", "", "characters", "startIndex", "okhttp"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final CacheControl parse(@NotNull Headers headers) {
            Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
            boolean noCache = false;
            boolean noStore = false;
            int maxAgeSeconds = -1;
            int sMaxAgeSeconds = -1;
            boolean isPrivate = false;
            boolean isPublic = false;
            boolean mustRevalidate = false;
            int maxStaleSeconds = -1;
            int minFreshSeconds = -1;
            boolean onlyIfCached = false;
            boolean noTransform = false;
            boolean immutable = false;
            boolean canUseHeaderValue = true;
            String headerValue = null;
            int n = 0;
            int n2 = headers.size();
            while (n < n2) {
                void i;
                block34: {
                    String value;
                    block33: {
                        String name;
                        block32: {
                            name = headers.name((int)i);
                            value = headers.value((int)i);
                            if (!StringsKt.equals((String)name, (String)"Cache-Control", (boolean)true)) break block32;
                            if (headerValue != null) {
                                canUseHeaderValue = false;
                            } else {
                                headerValue = value;
                            }
                            break block33;
                        }
                        if (!StringsKt.equals((String)name, (String)"Pragma", (boolean)true)) break block34;
                        canUseHeaderValue = false;
                    }
                    int pos = 0;
                    while (pos < value.length()) {
                        String $this$trim$iv;
                        int tokenStart = pos;
                        pos = this.indexOfElement(value, "=,;", pos);
                        String string = value;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(tokenStart, pos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl2 = false;
                            boolean bl3 = match$iv$iv = it <= ' ';
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        String directive = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                        String parameter = null;
                        if (pos == value.length() || value.charAt(pos) == ',' || value.charAt(pos) == ';') {
                            ++pos;
                            parameter = null;
                        } else {
                            int parameterStart;
                            ++pos;
                            if ((pos = UtilKt.indexOfNonWhitespace(value, pos)) < value.length() && value.charAt(pos) == '\"') {
                                parameterStart = ++pos;
                                pos = this.indexOfElement(value, "\"", pos);
                                $this$trim$iv$iv = value;
                                $i$f$trim2 = false;
                                CharSequence charSequence = $this$trim$iv$iv;
                                if (charSequence == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string3 = ((String)charSequence).substring(parameterStart, pos);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                parameter = string3;
                                ++pos;
                            } else {
                                String $this$trim$iv2;
                                parameterStart = pos;
                                pos = this.indexOfElement(value, ",;", pos);
                                $this$trim$iv$iv = value;
                                $i$f$trim2 = false;
                                CharSequence charSequence = $this$trim$iv$iv;
                                if (charSequence == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)((String)charSequence).substring(parameterStart, pos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                $i$f$trim2 = false;
                                CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
                                boolean $i$f$trim3 = false;
                                int startIndex$iv$iv2 = 0;
                                int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                                boolean startFound$iv$iv2 = false;
                                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                                    char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                                    boolean bl4 = false;
                                    boolean bl5 = match$iv$iv = it <= ' ';
                                    if (!startFound$iv$iv2) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv2 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv2;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv2;
                                }
                                parameter = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                            }
                        }
                        if (StringsKt.equals((String)"no-cache", (String)directive, (boolean)true)) {
                            noCache = true;
                            continue;
                        }
                        if (StringsKt.equals((String)"no-store", (String)directive, (boolean)true)) {
                            noStore = true;
                            continue;
                        }
                        if (StringsKt.equals((String)"max-age", (String)directive, (boolean)true)) {
                            maxAgeSeconds = UtilKt.toNonNegativeInt(parameter, -1);
                            continue;
                        }
                        if (StringsKt.equals((String)"s-maxage", (String)directive, (boolean)true)) {
                            sMaxAgeSeconds = UtilKt.toNonNegativeInt(parameter, -1);
                            continue;
                        }
                        if (StringsKt.equals((String)"private", (String)directive, (boolean)true)) {
                            isPrivate = true;
                            continue;
                        }
                        if (StringsKt.equals((String)"public", (String)directive, (boolean)true)) {
                            isPublic = true;
                            continue;
                        }
                        if (StringsKt.equals((String)"must-revalidate", (String)directive, (boolean)true)) {
                            mustRevalidate = true;
                            continue;
                        }
                        if (StringsKt.equals((String)"max-stale", (String)directive, (boolean)true)) {
                            maxStaleSeconds = UtilKt.toNonNegativeInt(parameter, Integer.MAX_VALUE);
                            continue;
                        }
                        if (StringsKt.equals((String)"min-fresh", (String)directive, (boolean)true)) {
                            minFreshSeconds = UtilKt.toNonNegativeInt(parameter, -1);
                            continue;
                        }
                        if (StringsKt.equals((String)"only-if-cached", (String)directive, (boolean)true)) {
                            onlyIfCached = true;
                            continue;
                        }
                        if (StringsKt.equals((String)"no-transform", (String)directive, (boolean)true)) {
                            noTransform = true;
                            continue;
                        }
                        if (!StringsKt.equals((String)"immutable", (String)directive, (boolean)true)) continue;
                        immutable = true;
                    }
                }
                ++i;
            }
            if (!canUseHeaderValue) {
                headerValue = null;
            }
            return new CacheControl(noCache, noStore, maxAgeSeconds, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue, null);
        }

        /*
         * WARNING - void declaration
         */
        private final int indexOfElement(@NotNull String $this$indexOfElement, String characters, int startIndex) {
            int n = startIndex;
            int n2 = $this$indexOfElement.length();
            while (n < n2) {
                void i;
                if (StringsKt.contains$default((CharSequence)characters, (char)$this$indexOfElement.charAt((int)i), (boolean)false, (int)2, null)) {
                    return (int)i;
                }
                ++i;
            }
            return $this$indexOfElement.length();
        }

        static /* synthetic */ int indexOfElement$default(Companion companion, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.indexOfElement(string, string2, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

