/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.maven;

import com.google.common.collect.ImmutableList;
import com.querydsl.maven.Mapping;
import com.querydsl.sql.Configuration;

public class RenameMapping
implements Mapping {
    String fromSchema;
    String fromTable;
    String fromColumn;
    String toSchema;
    String toTable;
    String toColumn;

    @Override
    public void apply(Configuration configuration) {
        if (this.fromSchema != null) {
            if (this.fromTable != null && this.fromColumn != null && this.toColumn != null) {
                configuration.registerColumnOverride(this.fromSchema, this.fromTable, this.fromColumn, this.toColumn);
            } else if (this.fromTable != null && this.toTable != null) {
                if (this.toSchema != null) {
                    configuration.registerTableOverride(this.fromSchema, this.fromTable, this.toSchema, this.toTable);
                } else {
                    configuration.registerTableOverride(this.fromSchema, this.fromTable, this.toTable);
                }
            } else if (this.toSchema != null) {
                configuration.registerSchemaOverride(this.fromSchema, this.toSchema);
            } else {
                this.insufficientArgs();
            }
        } else if (this.fromTable != null) {
            if (this.fromColumn != null && this.toColumn != null) {
                configuration.registerColumnOverride(this.fromTable, this.fromColumn, this.toColumn);
            } else if (this.toTable != null) {
                configuration.registerTableOverride(this.fromTable, this.toTable);
            } else {
                this.insufficientArgs();
            }
        } else {
            this.insufficientArgs();
        }
    }

    private void insufficientArgs() {
        throw new IllegalArgumentException("Insufficient args " + ImmutableList.of((Object)this.fromSchema, (Object)this.fromTable, (Object)this.fromColumn) + " to " + ImmutableList.of((Object)this.toSchema, (Object)this.toTable, (Object)this.toColumn));
    }
}

