/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

public class CompileMojo
extends AbstractMojo {
    private static final String JAVA_FILE_FILTER = "/*.java";
    private static final String[] ALL_JAVA_FILES_FILTER = new String[]{"**/*.java"};
    private MavenProject project;
    private File sourceFolder;
    private String sourceEncoding;
    private String source;
    private String target;
    private boolean testClasspath;
    private Map<String, String> compilerOptions;
    private BuildContext buildContext;

    private String buildCompileClasspath() {
        List pathElements = null;
        try {
            pathElements = this.testClasspath ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().warn((CharSequence)"exception calling getCompileClasspathElements", (Throwable)e);
            return null;
        }
        if (pathElements.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < pathElements.size(); ++i) {
            if (i > 0) {
                result.append(File.pathSeparatorChar);
            }
            result.append((String)pathElements.get(i));
        }
        return result.toString();
    }

    private List<String> getCompilerOptions() {
        LinkedHashMap<String, String> compilerOpts = new LinkedHashMap<String, String>();
        String cp = this.buildCompileClasspath();
        if (cp != null) {
            compilerOpts.put("cp", cp);
        }
        compilerOpts.put("proc:none", null);
        if (this.source != null) {
            compilerOpts.put("-source", this.source);
        }
        if (this.target != null) {
            compilerOpts.put("-target", this.target);
        }
        if (this.sourceEncoding != null) {
            compilerOpts.put("encoding", this.sourceEncoding);
        }
        if (this.testClasspath) {
            compilerOpts.put("d", this.project.getBuild().getTestOutputDirectory());
        } else {
            compilerOpts.put("d", this.project.getBuild().getOutputDirectory());
        }
        if (this.compilerOptions != null) {
            compilerOpts.putAll(this.compilerOptions);
        }
        ArrayList<String> opts = new ArrayList<String>(compilerOpts.size() * 2);
        for (Map.Entry compilerOption : compilerOpts.entrySet()) {
            opts.add("-" + (String)compilerOption.getKey());
            String value = (String)compilerOption.getValue();
            if (value == null) continue;
            opts.add(value);
        }
        return opts;
    }

    private Set<File> getJavaFiles(File directory) {
        String[] filters = ALL_JAVA_FILES_FILTER;
        HashSet<File> files = new HashSet<File>();
        Scanner scanner = this.buildContext.newScanner(directory);
        scanner.setIncludes(filters);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        if (includedFiles != null) {
            for (String includedFile : includedFiles) {
                files.add(new File(scanner.getBasedir(), includedFile));
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager sjfm = jc.getStandardFileManager(null, null, null);
        try {
            Set<File> generatedFiles = this.getJavaFiles(this.sourceFolder);
            Iterable<? extends JavaFileObject> fileObjects = sjfm.getJavaFileObjectsFromFiles(generatedFiles);
            List<String> opts = this.getCompilerOptions();
            jc.getTask(null, null, null, opts, null, fileObjects).call();
        }
        finally {
            try {
                sjfm.close();
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSourceFolder(File sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTestClasspath(boolean testClasspath) {
        this.testClasspath = testClasspath;
    }

    public void setCompilerOptions(Map<String, String> compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }
}

