/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.util.security;

import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtUser
implements UserDetails {
    private String userId;
    private String username;
    private String password;
    private Integer available;
    private Collection<? extends GrantedAuthority> authorities;

    public JwtUser() {
    }

    public JwtUser(String userId, String username, String password, Integer available, Collection<? extends GrantedAuthority> authorities) {
        this.userId = userId;
        this.username = username;
        this.password = password;
        this.available = available;
        this.authorities = authorities;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return !"0".equals(this.available);
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getAvailable() {
        return this.available;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAvailable(Integer available) {
        this.available = available;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtUser)) {
            return false;
        }
        JwtUser other = (JwtUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$available = this.getAvailable();
        Integer other$available = other.getAvailable();
        if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Collection<? extends GrantedAuthority> this$authorities = this.getAuthorities();
        Collection<? extends GrantedAuthority> other$authorities = other.getAuthorities();
        return !(this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $available = this.getAvailable();
        result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Collection<? extends GrantedAuthority> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        return result;
    }

    public String toString() {
        return "JwtUser(userId=" + this.getUserId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", available=" + this.getAvailable() + ", authorities=" + this.getAuthorities() + ")";
    }
}

