/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class HashUtils {
    public static MessageDigest getDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException var4) {
            String string = "No native '" + algorithmName + "' MessageDigest instance available on the current JVM.";
            return null;
        }
    }

    public static String hashHex(String algorithmName, String source, String salt, int hashIterations) {
        if (salt == null) {
            return HashUtils.hashHex(algorithmName, source.getBytes(StandardCharsets.UTF_8), null, hashIterations);
        }
        return HashUtils.hashHex(algorithmName, source.getBytes(StandardCharsets.UTF_8), salt.getBytes(StandardCharsets.UTF_8), hashIterations);
    }

    public static String hashHex(String algorithmName, byte[] bytes, byte[] salt, int hashIterations) {
        byte[] hash = HashUtils.hash(bytes, algorithmName, salt, hashIterations);
        return Hex.encodeHexString((byte[])hash);
    }

    public static byte[] hash(byte[] bytes, String algorithmName, byte[] salt, int hashIterations) {
        MessageDigest digest = HashUtils.getDigest(algorithmName);
        if (salt != null) {
            digest.reset();
            digest.update(salt);
        }
        byte[] hashed = digest.digest(bytes);
        int iterations = hashIterations - 1;
        for (int i = 0; i < iterations; ++i) {
            digest.reset();
            hashed = digest.digest(hashed);
        }
        return hashed;
    }
}

