/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DateUtil {
    public static String getCurrentTime() {
        Date date = new Date();
        String stringDate = String.format("%tF %<tT", date);
        return stringDate;
    }

    public static Date getDateByFormatString(String stringDate, String formatString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatString);
        Date date = dateFormat.parse(stringDate);
        return date;
    }

    public static int getDifferentDays(Date preDate, Date afterDate) {
        int preYear;
        int afterYear = DateUtil.getYear(afterDate);
        int preDayOfYear = DateUtil.getDayOfYear(preDate);
        int afterDayOfYear = DateUtil.getDayOfYear(afterDate);
        if (afterYear - preYear == 0) {
            return afterDayOfYear - preDayOfYear;
        }
        int diffDay = 0;
        for (preYear = DateUtil.getYear(preDate); preYear < afterYear; ++preYear) {
            if (diffDay == 0 && DateUtil.isLeapYear(preYear)) {
                diffDay = 366 - preDayOfYear;
                continue;
            }
            if (diffDay == 0 && !DateUtil.isLeapYear(preYear)) {
                diffDay = 365 - preDayOfYear;
                continue;
            }
            if (DateUtil.isLeapYear(preYear)) {
                diffDay += 366;
                continue;
            }
            diffDay += 365;
        }
        return diffDay += afterDayOfYear;
    }

    public static int getDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(6);
        return day;
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        return year;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static long getTime() {
        long time = new Date().getTime();
        return time;
    }

    public static List<String> getRecent30DateList() {
        String date;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        Date today = new Date();
        String maxDateStr = date = fmt.format(today);
        String minDateStr = "";
        Calendar calc = Calendar.getInstance();
        ArrayList<String> datefor30List = new ArrayList<String>();
        try {
            for (int i = 0; i < 30; ++i) {
                calc.setTime(fmt.parse(maxDateStr));
                calc.add(5, -i);
                Date minDate = calc.getTime();
                minDateStr = fmt.format(minDate);
                datefor30List.add(minDateStr);
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        Collections.reverse(datefor30List);
        return datefor30List;
    }
}

