/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectUtil {
    private static final Logger log = LoggerFactory.getLogger(CollectUtil.class);

    public String getClientIpAddress(HttpServletRequest request) {
        String clientIp = request.getHeader("x-forwarded-for");
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("WL-Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getRemoteAddr();
        }
        return clientIp;
    }

    public String getLocalIp() {
        InetAddress addr = null;
        String ip = "";
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6\u672c\u5730IP\u5931\u8d25");
        }
        if (addr != null) {
            ip = addr.getHostAddress().toString();
        }
        return ip;
    }
}

