/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.result;

import com.qiwenshare.common.result.ResultCodeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(name="\u7edf\u4e00\u7ed3\u679c\u8fd4\u56de", required=true)
public class RestResult<T> {
    @Schema(description="\u8bf7\u6c42\u662f\u5426\u6210\u529f", example="true")
    private Boolean success = true;
    @Schema(description="\u8fd4\u56de\u7801", example="000000")
    private Integer code = 0;
    @Schema(description="\u8fd4\u56de\u4fe1\u606f", example="\u6210\u529f")
    private String message;
    @Schema(description="\u8fd4\u56de\u6570\u636e")
    private T data;
    @Schema(description="\u8fd4\u56de\u6570\u636e\u5217\u8868")
    private List<T> dataList;
    @Schema(description="\u603b\u6570")
    private long total;

    public static RestResult success() {
        RestResult r = new RestResult();
        r.setSuccess(ResultCodeEnum.SUCCESS.getSuccess());
        r.setCode(ResultCodeEnum.SUCCESS.getCode());
        r.setMessage(ResultCodeEnum.SUCCESS.getMessage());
        return r;
    }

    public static RestResult fail() {
        RestResult r = new RestResult();
        r.setSuccess(ResultCodeEnum.UNKNOWN_ERROR.getSuccess());
        r.setCode(ResultCodeEnum.UNKNOWN_ERROR.getCode());
        r.setMessage(ResultCodeEnum.UNKNOWN_ERROR.getMessage());
        return r;
    }

    public static RestResult setResult(ResultCodeEnum result) {
        RestResult r = new RestResult();
        r.setSuccess(result.getSuccess());
        r.setCode(result.getCode());
        r.setMessage(result.getMessage());
        return r;
    }

    public RestResult data(T param) {
        this.setData(param);
        return this;
    }

    public RestResult dataList(List<T> param, long total) {
        this.setDataList(param);
        this.setTotal(total);
        return this;
    }

    public RestResult message(String message) {
        this.setMessage(message);
        return this;
    }

    public RestResult code(Integer code) {
        this.setCode(code);
        return this;
    }

    public RestResult success(Boolean success) {
        this.setSuccess(success);
        return this;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public long getTotal() {
        return this.total;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResult)) {
            return false;
        }
        RestResult other = (RestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        List<T> this$dataList = this.getDataList();
        List<T> other$dataList = other.getDataList();
        return !(this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        List<T> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        return result;
    }

    public String toString() {
        return "RestResult(success=" + this.getSuccess() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", dataList=" + this.getDataList() + ", total=" + this.getTotal() + ")";
    }
}

