/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.operation;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageOperation {
    private static final Logger log = LoggerFactory.getLogger(ImageOperation.class);

    public static void leftTotation(File inFile, File outFile, int angle) throws IOException {
        Thumbnails.of((File[])new File[]{inFile}).scale(1.0).outputQuality(1.0f).rotate((double)(-angle)).toFile(outFile);
    }

    public static void rightTotation(File inFile, File outFile, int angle) throws IOException {
        Thumbnails.of((File[])new File[]{inFile}).scale(1.0).outputQuality(1.0f).rotate((double)angle).toFile(outFile);
    }

    public static void thumbnailsImage(File inFile, File outFile, int width, int height) throws IOException {
        Thumbnails.of((File[])new File[]{inFile}).size(width, height).toFile(outFile);
    }

    public static InputStream thumbnailsImage(InputStream inputStream, File outFile, int width, int height) throws IOException {
        File parentFile = outFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        ByteArrayOutputStream baos = ImageOperation.cloneInputStream(inputStream);
        ByteArrayInputStream inputStream1 = new ByteArrayInputStream(baos.toByteArray());
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(baos.toByteArray());
        BufferedImage bufferedImage = ImageIO.read(inputStream1);
        if (bufferedImage == null) {
            return inputStream2;
        }
        int oriHeight = bufferedImage.getHeight();
        int oriWidth = bufferedImage.getWidth();
        if (oriHeight <= height || oriWidth <= width) {
            ImageIO.write((RenderedImage)bufferedImage, FilenameUtils.getExtension((String)outFile.getName()), outFile);
        } else {
            if (oriHeight < oriWidth) {
                Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).outputQuality(1.0f).scale(1.0).sourceRegion((Position)Positions.CENTER, oriHeight, oriHeight).toFile(outFile);
            } else {
                Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).outputQuality(1.0f).scale(1.0).sourceRegion((Position)Positions.CENTER, oriWidth, oriWidth).toFile(outFile);
            }
            Thumbnails.of((BufferedImage[])new BufferedImage[]{ImageIO.read(outFile)}).outputQuality(0.9).size(width, height).toFile(outFile);
        }
        return new FileInputStream(outFile);
    }

    public static InputStream thumbnailsImageForScale(InputStream inputStream, File outFile, long desFileSize) throws IOException {
        byte[] imageBytes = IOUtils.toByteArray((InputStream)inputStream);
        if (imageBytes == null || imageBytes.length <= 0 || (long)imageBytes.length < desFileSize * 1024L) {
            FileUtils.writeByteArrayToFile((File)outFile, (byte[])imageBytes);
            return new FileInputStream(outFile);
        }
        long srcSize = imageBytes.length;
        double accuracy = 0.4;
        try {
            while ((long)imageBytes.length > desFileSize * 1024L) {
                ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
                Thumbnails.of((InputStream[])new InputStream[]{is}).scale(accuracy).outputQuality(accuracy).toOutputStream((OutputStream)outputStream);
                imageBytes = outputStream.toByteArray();
            }
        }
        catch (Exception e) {
            log.error("\u3010\u56fe\u7247\u538b\u7f29\u3011msg=\u56fe\u7247\u538b\u7f29\u5931\u8d25!", (Throwable)e);
        }
        FileUtils.writeByteArrayToFile((File)outFile, (byte[])imageBytes);
        return new FileInputStream(outFile);
    }

    public static String getFileExtendName(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

