/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.operation;

import com.qiwenshare.common.operation.ExtractCallback;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperation {
    private static final Logger log = LoggerFactory.getLogger(FileOperation.class);
    private static Executor executor = Executors.newFixedThreadPool(20);

    public static File newFile(String fileUrl) {
        File file = new File(fileUrl);
        return file;
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        for (File newfile : file.listFiles()) {
            FileOperation.deleteFile(newfile);
        }
        return file.delete();
    }

    public static boolean deleteFile(String fileUrl) {
        File file = FileOperation.newFile(fileUrl);
        return FileOperation.deleteFile(file);
    }

    public static long getFileSize(String fileUrl) {
        File file = FileOperation.newFile(fileUrl);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public static long getFileSize(File file) {
        if (file == null) {
            return 0L;
        }
        return file.length();
    }

    public static boolean mkdir(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean mkdir(String fileUrl) {
        if (fileUrl == null) {
            return false;
        }
        File file = FileOperation.newFile(fileUrl);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int len = fileInputStream.read(buf);
            while (len != -1) {
                fileOutputStream.write(buf, 0, len);
                len = fileInputStream.read(buf);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        FileOperation.copyFile(in, out);
    }

    public static void copyFile(String srcUrl, String destUrl) throws IOException {
        if (srcUrl == null || destUrl == null) {
            return;
        }
        File srcFile = FileOperation.newFile(srcUrl);
        File descFile = FileOperation.newFile(destUrl);
        FileOperation.copyFile(srcFile, descFile);
    }

    public static List<String> unzip(File sourceFile, String destDirPath) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(sourceFile, "r");
        IInArchive archive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
        int[] in = new int[archive.getNumberOfItems()];
        for (int i = 0; i < in.length; ++i) {
            in[i] = i;
        }
        archive.extract(in, false, (IArchiveExtractCallback)new ExtractCallback(archive, destDirPath));
        File destFile = new File(destDirPath);
        Collection files = FileUtils.listFiles((File)destFile, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public boolean accept(File file, String s) {
                return true;
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return true;
            }

            public boolean accept(File file, String s) {
                return true;
            }
        });
        HashSet set = new HashSet();
        files.forEach(o -> {
            String path = o.getAbsolutePath().replace(destFile.getAbsolutePath(), "").replace("\\", "/");
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                set.add(path);
            }
        });
        ArrayList<String> res = new ArrayList<String>(set);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDataToFile(String filePath, String fileName, String data) {
        File file;
        BufferedWriter writer = null;
        File dir = new File(filePath);
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(file = new File(filePath + fileName)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
            writer.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("\u6587\u4ef6\u5199\u5165\u6210\u529f\uff01");
    }
}

