/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.logback.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.plumelog.core.LogMessageThreadLocal;
import com.plumelog.core.TraceId;
import com.plumelog.core.TraceMessage;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.util.DateUtil;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.LogExceptionStackTrace;
import com.plumelog.core.util.StringUtils;
import com.plumelog.core.util.TraceLogMessageFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.helpers.MessageFormatter;

public class LogMessageUtil {
    private static final AtomicLong SEQ_BUILDER = new AtomicLong();

    private static String isExpandRunLog(ILoggingEvent logEvent) {
        String traceId = null;
        if (!logEvent.getMDCPropertyMap().isEmpty() && (traceId = (String)logEvent.getMDCPropertyMap().get("traceId")) != null) {
            TraceId.logTraceID.set((Object)traceId);
        }
        return traceId;
    }

    public static String getLogMessage(BaseLogMessage baseLogMessage, ILoggingEvent iLoggingEvent) {
        Map mdc = iLoggingEvent.getMDCPropertyMap();
        Map map = StringUtils.entityToMap((Object)baseLogMessage);
        if (mdc != null) {
            map.putAll(mdc);
        }
        return GfJsonUtil.toJSONString((Object)map);
    }

    public static BaseLogMessage getLogMessage(String appName, String env, ILoggingEvent iLoggingEvent, String runModel) {
        LogMessageUtil.isExpandRunLog(iLoggingEvent);
        TraceMessage traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
        String formattedMessage = LogMessageUtil.getMessage(iLoggingEvent);
        if (formattedMessage.startsWith("TRACE:")) {
            return TraceLogMessageFactory.getTraceLogMessage((TraceMessage)traceMessage, (String)appName, (String)env, (long)iLoggingEvent.getTimeStamp());
        }
        RunLogMessage logMessage = TraceLogMessageFactory.getLogMessage((String)appName, (String)env, (String)formattedMessage, (long)iLoggingEvent.getTimeStamp());
        logMessage.setClassName(iLoggingEvent.getLoggerName());
        logMessage.setThreadName(iLoggingEvent.getThreadName());
        logMessage.setSeq(Long.valueOf(SEQ_BUILDER.getAndIncrement()));
        StackTraceElement[] stackTraceElements = null;
        if ("2".equals(runModel)) {
            stackTraceElements = iLoggingEvent.getCallerData();
        }
        if (stackTraceElements != null && stackTraceElements.length > 0) {
            StackTraceElement stackTraceElement = stackTraceElements[0];
            String method = stackTraceElement.getMethodName();
            String line = String.valueOf(stackTraceElement.getLineNumber());
            logMessage.setMethod(method + "(" + stackTraceElement.getFileName() + ":" + line + ")");
        } else {
            logMessage.setMethod(iLoggingEvent.getThreadName());
        }
        logMessage.setDateTime(DateUtil.getDatetimeNormalStrWithMills((long)iLoggingEvent.getTimeStamp()));
        logMessage.setLogLevel(iLoggingEvent.getLevel().toString());
        return logMessage;
    }

    private static String getMessage(ILoggingEvent logEvent) {
        if (logEvent.getLevel().equals(Level.ERROR)) {
            if (logEvent.getThrowableProxy() != null) {
                ThrowableProxy throwableProxy = (ThrowableProxy)logEvent.getThrowableProxy();
                Object[] args = new String[]{logEvent.getFormattedMessage() + "\n" + LogExceptionStackTrace.erroStackTrace((Object)throwableProxy.getThrowable()).toString()};
                return LogMessageUtil.packageMessage("{}", args);
            }
            Object[] args = logEvent.getArgumentArray();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof Throwable)) continue;
                    args[i] = LogExceptionStackTrace.erroStackTrace((Object)args[i]);
                }
                return LogMessageUtil.packageMessage(logEvent.getMessage(), args);
            }
        }
        return logEvent.getFormattedMessage();
    }

    private static String packageMessage(String message, Object[] args) {
        if (message != null && message.contains("{}")) {
            return MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        }
        return TraceLogMessageFactory.packageMessage((String)message, (Object[])args);
    }
}

