/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ShippingPreference;

public class VenmoWalletExperienceContext {
    private String brandName;
    private ShippingPreference shippingPreference;

    public VenmoWalletExperienceContext() {
        this.shippingPreference = ShippingPreference.GET_FROM_FILE;
    }

    public VenmoWalletExperienceContext(String brandName, ShippingPreference shippingPreference) {
        this.brandName = brandName;
        this.shippingPreference = shippingPreference;
    }

    @JsonGetter(value="brand_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return this.brandName;
    }

    @JsonSetter(value="brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @JsonGetter(value="shipping_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    @JsonSetter(value="shipping_preference")
    public void setShippingPreference(ShippingPreference shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    public String toString() {
        return "VenmoWalletExperienceContext [brandName=" + this.brandName + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brandName(this.getBrandName()).shippingPreference(this.getShippingPreference());
        return builder;
    }

    public static class Builder {
        private String brandName;
        private ShippingPreference shippingPreference = ShippingPreference.GET_FROM_FILE;

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder shippingPreference(ShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        public VenmoWalletExperienceContext build() {
            return new VenmoWalletExperienceContext(this.brandName, this.shippingPreference);
        }
    }
}

