/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.SetupTokenRequestCard;
import com.paypal.sdk.models.VaultPayPalWalletRequest;
import com.paypal.sdk.models.VaultTokenRequest;
import com.paypal.sdk.models.VaultVenmoRequest;

public class SetupTokenRequestPaymentSource {
    private SetupTokenRequestCard card;
    private VaultPayPalWalletRequest paypal;
    private VaultVenmoRequest venmo;
    private VaultTokenRequest token;

    public SetupTokenRequestPaymentSource() {
    }

    public SetupTokenRequestPaymentSource(SetupTokenRequestCard card, VaultPayPalWalletRequest paypal, VaultVenmoRequest venmo, VaultTokenRequest token) {
        this.card = card;
        this.paypal = paypal;
        this.venmo = venmo;
        this.token = token;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SetupTokenRequestCard getCard() {
        return this.card;
    }

    @JsonSetter(value="card")
    public void setCard(SetupTokenRequestCard card) {
        this.card = card;
    }

    @JsonGetter(value="paypal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultPayPalWalletRequest getPaypal() {
        return this.paypal;
    }

    @JsonSetter(value="paypal")
    public void setPaypal(VaultPayPalWalletRequest paypal) {
        this.paypal = paypal;
    }

    @JsonGetter(value="venmo")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultVenmoRequest getVenmo() {
        return this.venmo;
    }

    @JsonSetter(value="venmo")
    public void setVenmo(VaultVenmoRequest venmo) {
        this.venmo = venmo;
    }

    @JsonGetter(value="token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultTokenRequest getToken() {
        return this.token;
    }

    @JsonSetter(value="token")
    public void setToken(VaultTokenRequest token) {
        this.token = token;
    }

    public String toString() {
        return "SetupTokenRequestPaymentSource [card=" + this.card + ", paypal=" + this.paypal + ", venmo=" + this.venmo + ", token=" + this.token + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().card(this.getCard()).paypal(this.getPaypal()).venmo(this.getVenmo()).token(this.getToken());
        return builder;
    }

    public static class Builder {
        private SetupTokenRequestCard card;
        private VaultPayPalWalletRequest paypal;
        private VaultVenmoRequest venmo;
        private VaultTokenRequest token;

        public Builder card(SetupTokenRequestCard card) {
            this.card = card;
            return this;
        }

        public Builder paypal(VaultPayPalWalletRequest paypal) {
            this.paypal = paypal;
            return this;
        }

        public Builder venmo(VaultVenmoRequest venmo) {
            this.venmo = venmo;
            return this;
        }

        public Builder token(VaultTokenRequest token) {
            this.token = token;
            return this;
        }

        public SetupTokenRequestPaymentSource build() {
            return new SetupTokenRequestPaymentSource(this.card, this.paypal, this.venmo, this.token);
        }
    }
}

