/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CustomerRequest;
import com.paypal.sdk.models.SetupTokenRequestPaymentSource;

public class SetupTokenRequest {
    private CustomerRequest customer;
    private SetupTokenRequestPaymentSource paymentSource;

    public SetupTokenRequest() {
    }

    public SetupTokenRequest(SetupTokenRequestPaymentSource paymentSource, CustomerRequest customer) {
        this.customer = customer;
        this.paymentSource = paymentSource;
    }

    @JsonGetter(value="customer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerRequest getCustomer() {
        return this.customer;
    }

    @JsonSetter(value="customer")
    public void setCustomer(CustomerRequest customer) {
        this.customer = customer;
    }

    @JsonGetter(value="payment_source")
    public SetupTokenRequestPaymentSource getPaymentSource() {
        return this.paymentSource;
    }

    @JsonSetter(value="payment_source")
    public void setPaymentSource(SetupTokenRequestPaymentSource paymentSource) {
        this.paymentSource = paymentSource;
    }

    public String toString() {
        return "SetupTokenRequest [paymentSource=" + this.paymentSource + ", customer=" + this.customer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentSource).customer(this.getCustomer());
        return builder;
    }

    public static class Builder {
        private SetupTokenRequestPaymentSource paymentSource;
        private CustomerRequest customer;

        public Builder() {
        }

        public Builder(SetupTokenRequestPaymentSource paymentSource) {
            this.paymentSource = paymentSource;
        }

        public Builder paymentSource(SetupTokenRequestPaymentSource paymentSource) {
            this.paymentSource = paymentSource;
            return this;
        }

        public Builder customer(CustomerRequest customer) {
            this.customer = customer;
            return this;
        }

        public SetupTokenRequest build() {
            return new SetupTokenRequest(this.paymentSource, this.customer);
        }
    }
}

