/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.AmountWithBreakdown;
import com.paypal.sdk.models.Item;
import com.paypal.sdk.models.Payee;
import com.paypal.sdk.models.PaymentInstruction;
import com.paypal.sdk.models.ShippingDetails;
import com.paypal.sdk.models.SupplementaryData;
import java.util.List;

public class PurchaseUnitRequest {
    private String referenceId;
    private AmountWithBreakdown amount;
    private Payee payee;
    private PaymentInstruction paymentInstruction;
    private String description;
    private String customId;
    private String invoiceId;
    private String softDescriptor;
    private List<Item> items;
    private ShippingDetails shipping;
    private SupplementaryData supplementaryData;

    public PurchaseUnitRequest() {
    }

    public PurchaseUnitRequest(AmountWithBreakdown amount, String referenceId, Payee payee, PaymentInstruction paymentInstruction, String description, String customId, String invoiceId, String softDescriptor, List<Item> items, ShippingDetails shipping, SupplementaryData supplementaryData) {
        this.referenceId = referenceId;
        this.amount = amount;
        this.payee = payee;
        this.paymentInstruction = paymentInstruction;
        this.description = description;
        this.customId = customId;
        this.invoiceId = invoiceId;
        this.softDescriptor = softDescriptor;
        this.items = items;
        this.shipping = shipping;
        this.supplementaryData = supplementaryData;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonSetter(value="reference_id")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonGetter(value="amount")
    public AmountWithBreakdown getAmount() {
        return this.amount;
    }

    @JsonSetter(value="amount")
    public void setAmount(AmountWithBreakdown amount) {
        this.amount = amount;
    }

    @JsonGetter(value="payee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Payee getPayee() {
        return this.payee;
    }

    @JsonSetter(value="payee")
    public void setPayee(Payee payee) {
        this.payee = payee;
    }

    @JsonGetter(value="payment_instruction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaymentInstruction getPaymentInstruction() {
        return this.paymentInstruction;
    }

    @JsonSetter(value="payment_instruction")
    public void setPaymentInstruction(PaymentInstruction paymentInstruction) {
        this.paymentInstruction = paymentInstruction;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonGetter(value="custom_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomId() {
        return this.customId;
    }

    @JsonSetter(value="custom_id")
    public void setCustomId(String customId) {
        this.customId = customId;
    }

    @JsonGetter(value="invoice_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonSetter(value="invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    @JsonGetter(value="soft_descriptor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSoftDescriptor() {
        return this.softDescriptor;
    }

    @JsonSetter(value="soft_descriptor")
    public void setSoftDescriptor(String softDescriptor) {
        this.softDescriptor = softDescriptor;
    }

    @JsonGetter(value="items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Item> getItems() {
        return this.items;
    }

    @JsonSetter(value="items")
    public void setItems(List<Item> items) {
        this.items = items;
    }

    @JsonGetter(value="shipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @JsonSetter(value="shipping")
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @JsonGetter(value="supplementary_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SupplementaryData getSupplementaryData() {
        return this.supplementaryData;
    }

    @JsonSetter(value="supplementary_data")
    public void setSupplementaryData(SupplementaryData supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public String toString() {
        return "PurchaseUnitRequest [amount=" + this.amount + ", referenceId=" + this.referenceId + ", payee=" + this.payee + ", paymentInstruction=" + this.paymentInstruction + ", description=" + this.description + ", customId=" + this.customId + ", invoiceId=" + this.invoiceId + ", softDescriptor=" + this.softDescriptor + ", items=" + this.items + ", shipping=" + this.shipping + ", supplementaryData=" + this.supplementaryData + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amount).referenceId(this.getReferenceId()).payee(this.getPayee()).paymentInstruction(this.getPaymentInstruction()).description(this.getDescription()).customId(this.getCustomId()).invoiceId(this.getInvoiceId()).softDescriptor(this.getSoftDescriptor()).items(this.getItems()).shipping(this.getShipping()).supplementaryData(this.getSupplementaryData());
        return builder;
    }

    public static class Builder {
        private AmountWithBreakdown amount;
        private String referenceId;
        private Payee payee;
        private PaymentInstruction paymentInstruction;
        private String description;
        private String customId;
        private String invoiceId;
        private String softDescriptor;
        private List<Item> items;
        private ShippingDetails shipping;
        private SupplementaryData supplementaryData;

        public Builder() {
        }

        public Builder(AmountWithBreakdown amount) {
            this.amount = amount;
        }

        public Builder amount(AmountWithBreakdown amount) {
            this.amount = amount;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder payee(Payee payee) {
            this.payee = payee;
            return this;
        }

        public Builder paymentInstruction(PaymentInstruction paymentInstruction) {
            this.paymentInstruction = paymentInstruction;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder customId(String customId) {
            this.customId = customId;
            return this;
        }

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public Builder softDescriptor(String softDescriptor) {
            this.softDescriptor = softDescriptor;
            return this;
        }

        public Builder items(List<Item> items) {
            this.items = items;
            return this;
        }

        public Builder shipping(ShippingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder supplementaryData(SupplementaryData supplementaryData) {
            this.supplementaryData = supplementaryData;
            return this;
        }

        public PurchaseUnitRequest build() {
            return new PurchaseUnitRequest(this.amount, this.referenceId, this.payee, this.paymentInstruction, this.description, this.customId, this.invoiceId, this.softDescriptor, this.items, this.shipping, this.supplementaryData);
        }
    }
}

