/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ApplePayRequest;
import com.paypal.sdk.models.BLIKPaymentRequest;
import com.paypal.sdk.models.BancontactPaymentRequest;
import com.paypal.sdk.models.CardRequest;
import com.paypal.sdk.models.EPSPaymentRequest;
import com.paypal.sdk.models.GiropayPaymentRequest;
import com.paypal.sdk.models.GooglePayRequest;
import com.paypal.sdk.models.IDEALPaymentRequest;
import com.paypal.sdk.models.MyBankPaymentRequest;
import com.paypal.sdk.models.P24PaymentRequest;
import com.paypal.sdk.models.PayPalWallet;
import com.paypal.sdk.models.SofortPaymentRequest;
import com.paypal.sdk.models.Token;
import com.paypal.sdk.models.TrustlyPaymentRequest;
import com.paypal.sdk.models.VenmoWalletRequest;

public class PaymentSource {
    private CardRequest card;
    private Token token;
    private PayPalWallet paypal;
    private BancontactPaymentRequest bancontact;
    private BLIKPaymentRequest blik;
    private EPSPaymentRequest eps;
    private GiropayPaymentRequest giropay;
    private IDEALPaymentRequest ideal;
    private MyBankPaymentRequest mybank;
    private P24PaymentRequest p24;
    private SofortPaymentRequest sofort;
    private TrustlyPaymentRequest trustly;
    private ApplePayRequest applePay;
    private GooglePayRequest googlePay;
    private VenmoWalletRequest venmo;

    public PaymentSource() {
    }

    public PaymentSource(CardRequest card, Token token, PayPalWallet paypal, BancontactPaymentRequest bancontact, BLIKPaymentRequest blik, EPSPaymentRequest eps, GiropayPaymentRequest giropay, IDEALPaymentRequest ideal, MyBankPaymentRequest mybank, P24PaymentRequest p24, SofortPaymentRequest sofort, TrustlyPaymentRequest trustly, ApplePayRequest applePay, GooglePayRequest googlePay, VenmoWalletRequest venmo) {
        this.card = card;
        this.token = token;
        this.paypal = paypal;
        this.bancontact = bancontact;
        this.blik = blik;
        this.eps = eps;
        this.giropay = giropay;
        this.ideal = ideal;
        this.mybank = mybank;
        this.p24 = p24;
        this.sofort = sofort;
        this.trustly = trustly;
        this.applePay = applePay;
        this.googlePay = googlePay;
        this.venmo = venmo;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardRequest getCard() {
        return this.card;
    }

    @JsonSetter(value="card")
    public void setCard(CardRequest card) {
        this.card = card;
    }

    @JsonGetter(value="token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Token getToken() {
        return this.token;
    }

    @JsonSetter(value="token")
    public void setToken(Token token) {
        this.token = token;
    }

    @JsonGetter(value="paypal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalWallet getPaypal() {
        return this.paypal;
    }

    @JsonSetter(value="paypal")
    public void setPaypal(PayPalWallet paypal) {
        this.paypal = paypal;
    }

    @JsonGetter(value="bancontact")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BancontactPaymentRequest getBancontact() {
        return this.bancontact;
    }

    @JsonSetter(value="bancontact")
    public void setBancontact(BancontactPaymentRequest bancontact) {
        this.bancontact = bancontact;
    }

    @JsonGetter(value="blik")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BLIKPaymentRequest getBlik() {
        return this.blik;
    }

    @JsonSetter(value="blik")
    public void setBlik(BLIKPaymentRequest blik) {
        this.blik = blik;
    }

    @JsonGetter(value="eps")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public EPSPaymentRequest getEps() {
        return this.eps;
    }

    @JsonSetter(value="eps")
    public void setEps(EPSPaymentRequest eps) {
        this.eps = eps;
    }

    @JsonGetter(value="giropay")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GiropayPaymentRequest getGiropay() {
        return this.giropay;
    }

    @JsonSetter(value="giropay")
    public void setGiropay(GiropayPaymentRequest giropay) {
        this.giropay = giropay;
    }

    @JsonGetter(value="ideal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public IDEALPaymentRequest getIdeal() {
        return this.ideal;
    }

    @JsonSetter(value="ideal")
    public void setIdeal(IDEALPaymentRequest ideal) {
        this.ideal = ideal;
    }

    @JsonGetter(value="mybank")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MyBankPaymentRequest getMybank() {
        return this.mybank;
    }

    @JsonSetter(value="mybank")
    public void setMybank(MyBankPaymentRequest mybank) {
        this.mybank = mybank;
    }

    @JsonGetter(value="p24")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public P24PaymentRequest getP24() {
        return this.p24;
    }

    @JsonSetter(value="p24")
    public void setP24(P24PaymentRequest p24) {
        this.p24 = p24;
    }

    @JsonGetter(value="sofort")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SofortPaymentRequest getSofort() {
        return this.sofort;
    }

    @JsonSetter(value="sofort")
    public void setSofort(SofortPaymentRequest sofort) {
        this.sofort = sofort;
    }

    @JsonGetter(value="trustly")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TrustlyPaymentRequest getTrustly() {
        return this.trustly;
    }

    @JsonSetter(value="trustly")
    public void setTrustly(TrustlyPaymentRequest trustly) {
        this.trustly = trustly;
    }

    @JsonGetter(value="apple_pay")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ApplePayRequest getApplePay() {
        return this.applePay;
    }

    @JsonSetter(value="apple_pay")
    public void setApplePay(ApplePayRequest applePay) {
        this.applePay = applePay;
    }

    @JsonGetter(value="google_pay")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GooglePayRequest getGooglePay() {
        return this.googlePay;
    }

    @JsonSetter(value="google_pay")
    public void setGooglePay(GooglePayRequest googlePay) {
        this.googlePay = googlePay;
    }

    @JsonGetter(value="venmo")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VenmoWalletRequest getVenmo() {
        return this.venmo;
    }

    @JsonSetter(value="venmo")
    public void setVenmo(VenmoWalletRequest venmo) {
        this.venmo = venmo;
    }

    public String toString() {
        return "PaymentSource [card=" + this.card + ", token=" + this.token + ", paypal=" + this.paypal + ", bancontact=" + this.bancontact + ", blik=" + this.blik + ", eps=" + this.eps + ", giropay=" + this.giropay + ", ideal=" + this.ideal + ", mybank=" + this.mybank + ", p24=" + this.p24 + ", sofort=" + this.sofort + ", trustly=" + this.trustly + ", applePay=" + this.applePay + ", googlePay=" + this.googlePay + ", venmo=" + this.venmo + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().card(this.getCard()).token(this.getToken()).paypal(this.getPaypal()).bancontact(this.getBancontact()).blik(this.getBlik()).eps(this.getEps()).giropay(this.getGiropay()).ideal(this.getIdeal()).mybank(this.getMybank()).p24(this.getP24()).sofort(this.getSofort()).trustly(this.getTrustly()).applePay(this.getApplePay()).googlePay(this.getGooglePay()).venmo(this.getVenmo());
        return builder;
    }

    public static class Builder {
        private CardRequest card;
        private Token token;
        private PayPalWallet paypal;
        private BancontactPaymentRequest bancontact;
        private BLIKPaymentRequest blik;
        private EPSPaymentRequest eps;
        private GiropayPaymentRequest giropay;
        private IDEALPaymentRequest ideal;
        private MyBankPaymentRequest mybank;
        private P24PaymentRequest p24;
        private SofortPaymentRequest sofort;
        private TrustlyPaymentRequest trustly;
        private ApplePayRequest applePay;
        private GooglePayRequest googlePay;
        private VenmoWalletRequest venmo;

        public Builder card(CardRequest card) {
            this.card = card;
            return this;
        }

        public Builder token(Token token) {
            this.token = token;
            return this;
        }

        public Builder paypal(PayPalWallet paypal) {
            this.paypal = paypal;
            return this;
        }

        public Builder bancontact(BancontactPaymentRequest bancontact) {
            this.bancontact = bancontact;
            return this;
        }

        public Builder blik(BLIKPaymentRequest blik) {
            this.blik = blik;
            return this;
        }

        public Builder eps(EPSPaymentRequest eps) {
            this.eps = eps;
            return this;
        }

        public Builder giropay(GiropayPaymentRequest giropay) {
            this.giropay = giropay;
            return this;
        }

        public Builder ideal(IDEALPaymentRequest ideal) {
            this.ideal = ideal;
            return this;
        }

        public Builder mybank(MyBankPaymentRequest mybank) {
            this.mybank = mybank;
            return this;
        }

        public Builder p24(P24PaymentRequest p24) {
            this.p24 = p24;
            return this;
        }

        public Builder sofort(SofortPaymentRequest sofort) {
            this.sofort = sofort;
            return this;
        }

        public Builder trustly(TrustlyPaymentRequest trustly) {
            this.trustly = trustly;
            return this;
        }

        public Builder applePay(ApplePayRequest applePay) {
            this.applePay = applePay;
            return this;
        }

        public Builder googlePay(GooglePayRequest googlePay) {
            this.googlePay = googlePay;
            return this;
        }

        public Builder venmo(VenmoWalletRequest venmo) {
            this.venmo = venmo;
            return this;
        }

        public PaymentSource build() {
            return new PaymentSource(this.card, this.token, this.paypal, this.bancontact, this.blik, this.eps, this.giropay, this.ideal, this.mybank, this.p24, this.sofort, this.trustly, this.applePay, this.googlePay, this.venmo);
        }
    }
}

