/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PayPalPaymentTokenCustomerType;
import com.paypal.sdk.models.PayPalPaymentTokenUsagePattern;
import com.paypal.sdk.models.PayPalPaymentTokenUsageType;
import com.paypal.sdk.models.StoreInVaultInstruction;

public class PayPalWalletVaultInstruction {
    private StoreInVaultInstruction storeInVault;
    private String description;
    private PayPalPaymentTokenUsagePattern usagePattern;
    private PayPalPaymentTokenUsageType usageType;
    private PayPalPaymentTokenCustomerType customerType;
    private Boolean permitMultiplePaymentTokens;

    public PayPalWalletVaultInstruction() {
        this.customerType = PayPalPaymentTokenCustomerType.CONSUMER;
        this.permitMultiplePaymentTokens = false;
    }

    public PayPalWalletVaultInstruction(PayPalPaymentTokenUsageType usageType, StoreInVaultInstruction storeInVault, String description, PayPalPaymentTokenUsagePattern usagePattern, PayPalPaymentTokenCustomerType customerType, Boolean permitMultiplePaymentTokens) {
        this.storeInVault = storeInVault;
        this.description = description;
        this.usagePattern = usagePattern;
        this.usageType = usageType;
        this.customerType = customerType;
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    @JsonGetter(value="store_in_vault")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StoreInVaultInstruction getStoreInVault() {
        return this.storeInVault;
    }

    @JsonSetter(value="store_in_vault")
    public void setStoreInVault(StoreInVaultInstruction storeInVault) {
        this.storeInVault = storeInVault;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonGetter(value="usage_pattern")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalPaymentTokenUsagePattern getUsagePattern() {
        return this.usagePattern;
    }

    @JsonSetter(value="usage_pattern")
    public void setUsagePattern(PayPalPaymentTokenUsagePattern usagePattern) {
        this.usagePattern = usagePattern;
    }

    @JsonGetter(value="usage_type")
    public PayPalPaymentTokenUsageType getUsageType() {
        return this.usageType;
    }

    @JsonSetter(value="usage_type")
    public void setUsageType(PayPalPaymentTokenUsageType usageType) {
        this.usageType = usageType;
    }

    @JsonGetter(value="customer_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalPaymentTokenCustomerType getCustomerType() {
        return this.customerType;
    }

    @JsonSetter(value="customer_type")
    public void setCustomerType(PayPalPaymentTokenCustomerType customerType) {
        this.customerType = customerType;
    }

    @JsonGetter(value="permit_multiple_payment_tokens")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getPermitMultiplePaymentTokens() {
        return this.permitMultiplePaymentTokens;
    }

    @JsonSetter(value="permit_multiple_payment_tokens")
    public void setPermitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    public String toString() {
        return "PayPalWalletVaultInstruction [usageType=" + (Object)((Object)this.usageType) + ", storeInVault=" + (Object)((Object)this.storeInVault) + ", description=" + this.description + ", usagePattern=" + (Object)((Object)this.usagePattern) + ", customerType=" + (Object)((Object)this.customerType) + ", permitMultiplePaymentTokens=" + this.permitMultiplePaymentTokens + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.usageType).storeInVault(this.getStoreInVault()).description(this.getDescription()).usagePattern(this.getUsagePattern()).customerType(this.getCustomerType()).permitMultiplePaymentTokens(this.getPermitMultiplePaymentTokens());
        return builder;
    }

    public static class Builder {
        private PayPalPaymentTokenUsageType usageType;
        private StoreInVaultInstruction storeInVault;
        private String description;
        private PayPalPaymentTokenUsagePattern usagePattern;
        private PayPalPaymentTokenCustomerType customerType = PayPalPaymentTokenCustomerType.CONSUMER;
        private Boolean permitMultiplePaymentTokens = false;

        public Builder() {
        }

        public Builder(PayPalPaymentTokenUsageType usageType) {
            this.usageType = usageType;
        }

        public Builder usageType(PayPalPaymentTokenUsageType usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder storeInVault(StoreInVaultInstruction storeInVault) {
            this.storeInVault = storeInVault;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder usagePattern(PayPalPaymentTokenUsagePattern usagePattern) {
            this.usagePattern = usagePattern;
            return this;
        }

        public Builder customerType(PayPalPaymentTokenCustomerType customerType) {
            this.customerType = customerType;
            return this;
        }

        public Builder permitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
            this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
            return this;
        }

        public PayPalWalletVaultInstruction build() {
            return new PayPalWalletVaultInstruction(this.usageType, this.storeInVault, this.description, this.usagePattern, this.customerType, this.permitMultiplePaymentTokens);
        }
    }
}

