/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderAuthorizeRequest;

public class OrdersAuthorizeInput {
    private String id;
    private String contentType;
    private String payPalRequestId;
    private String prefer;
    private String payPalClientMetadataId;
    private String payPalAuthAssertion;
    private OrderAuthorizeRequest body;

    public OrdersAuthorizeInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public OrdersAuthorizeInput(String id, String contentType, String payPalRequestId, String prefer, String payPalClientMetadataId, String payPalAuthAssertion, OrderAuthorizeRequest body) {
        this.id = id;
        this.contentType = contentType;
        this.payPalRequestId = payPalRequestId;
        this.prefer = prefer;
        this.payPalClientMetadataId = payPalClientMetadataId;
        this.payPalAuthAssertion = payPalAuthAssertion;
        this.body = body;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalRequestId() {
        return this.payPalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPayPalRequestId(String payPalRequestId) {
        this.payPalRequestId = payPalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="PayPal-Client-Metadata-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalClientMetadataId() {
        return this.payPalClientMetadataId;
    }

    @JsonSetter(value="PayPal-Client-Metadata-Id")
    public void setPayPalClientMetadataId(String payPalClientMetadataId) {
        this.payPalClientMetadataId = payPalClientMetadataId;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalAuthAssertion() {
        return this.payPalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPayPalAuthAssertion(String payPalAuthAssertion) {
        this.payPalAuthAssertion = payPalAuthAssertion;
    }

    @JsonGetter(value="body")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderAuthorizeRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(OrderAuthorizeRequest body) {
        this.body = body;
    }

    public String toString() {
        return "OrdersAuthorizeInput [id=" + this.id + ", contentType=" + this.contentType + ", payPalRequestId=" + this.payPalRequestId + ", prefer=" + this.prefer + ", payPalClientMetadataId=" + this.payPalClientMetadataId + ", payPalAuthAssertion=" + this.payPalAuthAssertion + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.contentType).payPalRequestId(this.getPayPalRequestId()).prefer(this.getPrefer()).payPalClientMetadataId(this.getPayPalClientMetadataId()).payPalAuthAssertion(this.getPayPalAuthAssertion()).body(this.getBody());
        return builder;
    }

    public static class Builder {
        private String id;
        private String contentType = "application/json";
        private String payPalRequestId;
        private String prefer = "return=minimal";
        private String payPalClientMetadataId;
        private String payPalAuthAssertion;
        private OrderAuthorizeRequest body;

        public Builder() {
        }

        public Builder(String id, String contentType) {
            this.id = id;
            this.contentType = contentType;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder payPalRequestId(String payPalRequestId) {
            this.payPalRequestId = payPalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder payPalClientMetadataId(String payPalClientMetadataId) {
            this.payPalClientMetadataId = payPalClientMetadataId;
            return this;
        }

        public Builder payPalAuthAssertion(String payPalAuthAssertion) {
            this.payPalAuthAssertion = payPalAuthAssertion;
            return this;
        }

        public Builder body(OrderAuthorizeRequest body) {
            this.body = body;
            return this;
        }

        public OrdersAuthorizeInput build() {
            return new OrdersAuthorizeInput(this.id, this.contentType, this.payPalRequestId, this.prefer, this.payPalClientMetadataId, this.payPalAuthAssertion, this.body);
        }
    }
}

