/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CheckoutPaymentIntent;
import com.paypal.sdk.models.OrderApplicationContext;
import com.paypal.sdk.models.Payer;
import com.paypal.sdk.models.PaymentSource;
import com.paypal.sdk.models.PurchaseUnitRequest;
import java.util.List;

public class OrderRequest {
    private CheckoutPaymentIntent intent;
    private Payer payer;
    private List<PurchaseUnitRequest> purchaseUnits;
    private PaymentSource paymentSource;
    private OrderApplicationContext applicationContext;

    public OrderRequest() {
    }

    public OrderRequest(CheckoutPaymentIntent intent, List<PurchaseUnitRequest> purchaseUnits, Payer payer, PaymentSource paymentSource, OrderApplicationContext applicationContext) {
        this.intent = intent;
        this.payer = payer;
        this.purchaseUnits = purchaseUnits;
        this.paymentSource = paymentSource;
        this.applicationContext = applicationContext;
    }

    @JsonGetter(value="intent")
    public CheckoutPaymentIntent getIntent() {
        return this.intent;
    }

    @JsonSetter(value="intent")
    public void setIntent(CheckoutPaymentIntent intent) {
        this.intent = intent;
    }

    @JsonGetter(value="payer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Payer getPayer() {
        return this.payer;
    }

    @JsonSetter(value="payer")
    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    @JsonGetter(value="purchase_units")
    public List<PurchaseUnitRequest> getPurchaseUnits() {
        return this.purchaseUnits;
    }

    @JsonSetter(value="purchase_units")
    public void setPurchaseUnits(List<PurchaseUnitRequest> purchaseUnits) {
        this.purchaseUnits = purchaseUnits;
    }

    @JsonGetter(value="payment_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaymentSource getPaymentSource() {
        return this.paymentSource;
    }

    @JsonSetter(value="payment_source")
    public void setPaymentSource(PaymentSource paymentSource) {
        this.paymentSource = paymentSource;
    }

    @JsonGetter(value="application_context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @JsonSetter(value="application_context")
    public void setApplicationContext(OrderApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String toString() {
        return "OrderRequest [intent=" + (Object)((Object)this.intent) + ", purchaseUnits=" + this.purchaseUnits + ", payer=" + this.payer + ", paymentSource=" + this.paymentSource + ", applicationContext=" + this.applicationContext + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.intent, this.purchaseUnits).payer(this.getPayer()).paymentSource(this.getPaymentSource()).applicationContext(this.getApplicationContext());
        return builder;
    }

    public static class Builder {
        private CheckoutPaymentIntent intent;
        private List<PurchaseUnitRequest> purchaseUnits;
        private Payer payer;
        private PaymentSource paymentSource;
        private OrderApplicationContext applicationContext;

        public Builder() {
        }

        public Builder(CheckoutPaymentIntent intent, List<PurchaseUnitRequest> purchaseUnits) {
            this.intent = intent;
            this.purchaseUnits = purchaseUnits;
        }

        public Builder intent(CheckoutPaymentIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder purchaseUnits(List<PurchaseUnitRequest> purchaseUnits) {
            this.purchaseUnits = purchaseUnits;
            return this;
        }

        public Builder payer(Payer payer) {
            this.payer = payer;
            return this;
        }

        public Builder paymentSource(PaymentSource paymentSource) {
            this.paymentSource = paymentSource;
            return this;
        }

        public Builder applicationContext(OrderApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            return this;
        }

        public OrderRequest build() {
            return new OrderRequest(this.intent, this.purchaseUnits, this.payer, this.paymentSource, this.applicationContext);
        }
    }
}

