/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ApplePayRequest;
import com.paypal.sdk.models.CardRequest;
import com.paypal.sdk.models.GooglePayRequest;
import com.paypal.sdk.models.PayPalWallet;
import com.paypal.sdk.models.Token;
import com.paypal.sdk.models.VenmoWalletRequest;

public class OrderCaptureRequestPaymentSource {
    private CardRequest card;
    private Token token;
    private PayPalWallet paypal;
    private ApplePayRequest applePay;
    private GooglePayRequest googlePay;
    private VenmoWalletRequest venmo;

    public OrderCaptureRequestPaymentSource() {
    }

    public OrderCaptureRequestPaymentSource(CardRequest card, Token token, PayPalWallet paypal, ApplePayRequest applePay, GooglePayRequest googlePay, VenmoWalletRequest venmo) {
        this.card = card;
        this.token = token;
        this.paypal = paypal;
        this.applePay = applePay;
        this.googlePay = googlePay;
        this.venmo = venmo;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardRequest getCard() {
        return this.card;
    }

    @JsonSetter(value="card")
    public void setCard(CardRequest card) {
        this.card = card;
    }

    @JsonGetter(value="token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Token getToken() {
        return this.token;
    }

    @JsonSetter(value="token")
    public void setToken(Token token) {
        this.token = token;
    }

    @JsonGetter(value="paypal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayPalWallet getPaypal() {
        return this.paypal;
    }

    @JsonSetter(value="paypal")
    public void setPaypal(PayPalWallet paypal) {
        this.paypal = paypal;
    }

    @JsonGetter(value="apple_pay")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ApplePayRequest getApplePay() {
        return this.applePay;
    }

    @JsonSetter(value="apple_pay")
    public void setApplePay(ApplePayRequest applePay) {
        this.applePay = applePay;
    }

    @JsonGetter(value="google_pay")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GooglePayRequest getGooglePay() {
        return this.googlePay;
    }

    @JsonSetter(value="google_pay")
    public void setGooglePay(GooglePayRequest googlePay) {
        this.googlePay = googlePay;
    }

    @JsonGetter(value="venmo")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VenmoWalletRequest getVenmo() {
        return this.venmo;
    }

    @JsonSetter(value="venmo")
    public void setVenmo(VenmoWalletRequest venmo) {
        this.venmo = venmo;
    }

    public String toString() {
        return "OrderCaptureRequestPaymentSource [card=" + this.card + ", token=" + this.token + ", paypal=" + this.paypal + ", applePay=" + this.applePay + ", googlePay=" + this.googlePay + ", venmo=" + this.venmo + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().card(this.getCard()).token(this.getToken()).paypal(this.getPaypal()).applePay(this.getApplePay()).googlePay(this.getGooglePay()).venmo(this.getVenmo());
        return builder;
    }

    public static class Builder {
        private CardRequest card;
        private Token token;
        private PayPalWallet paypal;
        private ApplePayRequest applePay;
        private GooglePayRequest googlePay;
        private VenmoWalletRequest venmo;

        public Builder card(CardRequest card) {
            this.card = card;
            return this;
        }

        public Builder token(Token token) {
            this.token = token;
            return this;
        }

        public Builder paypal(PayPalWallet paypal) {
            this.paypal = paypal;
            return this;
        }

        public Builder applePay(ApplePayRequest applePay) {
            this.applePay = applePay;
            return this;
        }

        public Builder googlePay(GooglePayRequest googlePay) {
            this.googlePay = googlePay;
            return this;
        }

        public Builder venmo(VenmoWalletRequest venmo) {
            this.venmo = venmo;
            return this;
        }

        public OrderCaptureRequestPaymentSource build() {
            return new OrderCaptureRequestPaymentSource(this.card, this.token, this.paypal, this.applePay, this.googlePay, this.venmo);
        }
    }
}

