/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.LinkHTTPMethod;

public class LinkDescription {
    private String href;
    private String rel;
    private LinkHTTPMethod method;

    public LinkDescription() {
    }

    public LinkDescription(String href, String rel, LinkHTTPMethod method) {
        this.href = href;
        this.rel = rel;
        this.method = method;
    }

    @JsonGetter(value="href")
    public String getHref() {
        return this.href;
    }

    @JsonSetter(value="href")
    public void setHref(String href) {
        this.href = href;
    }

    @JsonGetter(value="rel")
    public String getRel() {
        return this.rel;
    }

    @JsonSetter(value="rel")
    public void setRel(String rel) {
        this.rel = rel;
    }

    @JsonGetter(value="method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LinkHTTPMethod getMethod() {
        return this.method;
    }

    @JsonSetter(value="method")
    public void setMethod(LinkHTTPMethod method) {
        this.method = method;
    }

    public String toString() {
        return "LinkDescription [href=" + this.href + ", rel=" + this.rel + ", method=" + (Object)((Object)this.method) + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.href, this.rel).method(this.getMethod());
        return builder;
    }

    public static class Builder {
        private String href;
        private String rel;
        private LinkHTTPMethod method;

        public Builder() {
        }

        public Builder(String href, String rel) {
            this.href = href;
            this.rel = rel;
        }

        public Builder href(String href) {
            this.href = href;
            return this;
        }

        public Builder rel(String rel) {
            this.rel = rel;
            return this;
        }

        public Builder method(LinkHTTPMethod method) {
            this.method = method;
            return this;
        }

        public LinkDescription build() {
            return new LinkDescription(this.href, this.rel, this.method);
        }
    }
}

