/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum GooglePayAuthenticationMethod {
    PAN_ONLY,
    CRYPTOGRAM_3DS,
    _UNKNOWN;

    private static TreeMap<String, GooglePayAuthenticationMethod> valueMap;
    private String value;

    @JsonCreator
    public static GooglePayAuthenticationMethod constructFromString(String toConvert) throws IOException {
        GooglePayAuthenticationMethod enumValue = GooglePayAuthenticationMethod.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static GooglePayAuthenticationMethod fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<GooglePayAuthenticationMethod> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (GooglePayAuthenticationMethod enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        GooglePayAuthenticationMethod.PAN_ONLY.value = "PAN_ONLY";
        GooglePayAuthenticationMethod.CRYPTOGRAM_3DS.value = "CRYPTOGRAM_3DS";
        GooglePayAuthenticationMethod._UNKNOWN.value = null;
        valueMap.put("PAN_ONLY", PAN_ONLY);
        valueMap.put("CRYPTOGRAM_3DS", CRYPTOGRAM_3DS);
    }
}

