/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderConfirmApplicationContext;
import com.paypal.sdk.models.PaymentSource;
import com.paypal.sdk.models.ProcessingInstruction;

public class ConfirmOrderRequest {
    private PaymentSource paymentSource;
    private ProcessingInstruction processingInstruction;
    private OrderConfirmApplicationContext applicationContext;

    public ConfirmOrderRequest() {
        this.processingInstruction = ProcessingInstruction.NO_INSTRUCTION;
    }

    public ConfirmOrderRequest(PaymentSource paymentSource, ProcessingInstruction processingInstruction, OrderConfirmApplicationContext applicationContext) {
        this.paymentSource = paymentSource;
        this.processingInstruction = processingInstruction;
        this.applicationContext = applicationContext;
    }

    @JsonGetter(value="payment_source")
    public PaymentSource getPaymentSource() {
        return this.paymentSource;
    }

    @JsonSetter(value="payment_source")
    public void setPaymentSource(PaymentSource paymentSource) {
        this.paymentSource = paymentSource;
    }

    @JsonGetter(value="processing_instruction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ProcessingInstruction getProcessingInstruction() {
        return this.processingInstruction;
    }

    @JsonSetter(value="processing_instruction")
    public void setProcessingInstruction(ProcessingInstruction processingInstruction) {
        this.processingInstruction = processingInstruction;
    }

    @JsonGetter(value="application_context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderConfirmApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @JsonSetter(value="application_context")
    public void setApplicationContext(OrderConfirmApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String toString() {
        return "ConfirmOrderRequest [paymentSource=" + this.paymentSource + ", processingInstruction=" + (Object)((Object)this.processingInstruction) + ", applicationContext=" + this.applicationContext + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentSource).processingInstruction(this.getProcessingInstruction()).applicationContext(this.getApplicationContext());
        return builder;
    }

    public static class Builder {
        private PaymentSource paymentSource;
        private ProcessingInstruction processingInstruction = ProcessingInstruction.NO_INSTRUCTION;
        private OrderConfirmApplicationContext applicationContext;

        public Builder() {
        }

        public Builder(PaymentSource paymentSource) {
            this.paymentSource = paymentSource;
        }

        public Builder paymentSource(PaymentSource paymentSource) {
            this.paymentSource = paymentSource;
            return this;
        }

        public Builder processingInstruction(ProcessingInstruction processingInstruction) {
            this.processingInstruction = processingInstruction;
            return this;
        }

        public Builder applicationContext(OrderConfirmApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            return this;
        }

        public ConfirmOrderRequest build() {
            return new ConfirmOrderRequest(this.paymentSource, this.processingInstruction, this.applicationContext);
        }
    }
}

