/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.PayeeBase;
import java.util.List;

public class CobrandedCard {
    private List<String> labels;
    private PayeeBase payee;
    private Money amount;

    public CobrandedCard() {
    }

    public CobrandedCard(List<String> labels, PayeeBase payee, Money amount) {
        this.labels = labels;
        this.payee = payee;
        this.amount = amount;
    }

    @JsonGetter(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonSetter(value="labels")
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @JsonGetter(value="payee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayeeBase getPayee() {
        return this.payee;
    }

    @JsonSetter(value="payee")
    public void setPayee(PayeeBase payee) {
        this.payee = payee;
    }

    @JsonGetter(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return this.amount;
    }

    @JsonSetter(value="amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    public String toString() {
        return "CobrandedCard [labels=" + this.labels + ", payee=" + this.payee + ", amount=" + this.amount + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().labels(this.getLabels()).payee(this.getPayee()).amount(this.getAmount());
        return builder;
    }

    public static class Builder {
        private List<String> labels;
        private PayeeBase payee;
        private Money amount;

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder payee(PayeeBase payee) {
            this.payee = payee;
            return this;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public CobrandedCard build() {
            return new CobrandedCard(this.labels, this.payee, this.amount);
        }
    }
}

