/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CardCustomerInformation;
import com.paypal.sdk.models.CardVerification;
import com.paypal.sdk.models.VaultInstructionBase;

public class CardAttributes {
    private CardCustomerInformation customer;
    private VaultInstructionBase vault;
    private CardVerification verification;

    public CardAttributes() {
    }

    public CardAttributes(CardCustomerInformation customer, VaultInstructionBase vault, CardVerification verification) {
        this.customer = customer;
        this.vault = vault;
        this.verification = verification;
    }

    @JsonGetter(value="customer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardCustomerInformation getCustomer() {
        return this.customer;
    }

    @JsonSetter(value="customer")
    public void setCustomer(CardCustomerInformation customer) {
        this.customer = customer;
    }

    @JsonGetter(value="vault")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultInstructionBase getVault() {
        return this.vault;
    }

    @JsonSetter(value="vault")
    public void setVault(VaultInstructionBase vault) {
        this.vault = vault;
    }

    @JsonGetter(value="verification")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CardVerification getVerification() {
        return this.verification;
    }

    @JsonSetter(value="verification")
    public void setVerification(CardVerification verification) {
        this.verification = verification;
    }

    public String toString() {
        return "CardAttributes [customer=" + this.customer + ", vault=" + this.vault + ", verification=" + this.verification + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customer(this.getCustomer()).vault(this.getVault()).verification(this.getVerification());
        return builder;
    }

    public static class Builder {
        private CardCustomerInformation customer;
        private VaultInstructionBase vault;
        private CardVerification verification;

        public Builder customer(CardCustomerInformation customer) {
            this.customer = customer;
            return this;
        }

        public Builder vault(VaultInstructionBase vault) {
            this.vault = vault;
            return this;
        }

        public Builder verification(CardVerification verification) {
            this.verification = verification;
            return this;
        }

        public CardAttributes build() {
            return new CardAttributes(this.customer, this.vault, this.verification);
        }
    }
}

