/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.BLIKExperienceContext;
import com.paypal.sdk.models.BLIKLevel0PaymentObject;
import com.paypal.sdk.models.BLIKOneClickPaymentRequest;

public class BLIKPaymentRequest {
    private String name;
    private String countryCode;
    private String email;
    private BLIKExperienceContext experienceContext;
    private BLIKLevel0PaymentObject level0;
    private BLIKOneClickPaymentRequest oneClick;

    public BLIKPaymentRequest() {
    }

    public BLIKPaymentRequest(String name, String countryCode, String email, BLIKExperienceContext experienceContext, BLIKLevel0PaymentObject level0, BLIKOneClickPaymentRequest oneClick) {
        this.name = name;
        this.countryCode = countryCode;
        this.email = email;
        this.experienceContext = experienceContext;
        this.level0 = level0;
        this.oneClick = oneClick;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="country_code")
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonSetter(value="country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @JsonGetter(value="email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmail() {
        return this.email;
    }

    @JsonSetter(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonGetter(value="experience_context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BLIKExperienceContext getExperienceContext() {
        return this.experienceContext;
    }

    @JsonSetter(value="experience_context")
    public void setExperienceContext(BLIKExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    @JsonGetter(value="level_0")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BLIKLevel0PaymentObject getLevel0() {
        return this.level0;
    }

    @JsonSetter(value="level_0")
    public void setLevel0(BLIKLevel0PaymentObject level0) {
        this.level0 = level0;
    }

    @JsonGetter(value="one_click")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BLIKOneClickPaymentRequest getOneClick() {
        return this.oneClick;
    }

    @JsonSetter(value="one_click")
    public void setOneClick(BLIKOneClickPaymentRequest oneClick) {
        this.oneClick = oneClick;
    }

    public String toString() {
        return "BLIKPaymentRequest [name=" + this.name + ", countryCode=" + this.countryCode + ", email=" + this.email + ", experienceContext=" + this.experienceContext + ", level0=" + this.level0 + ", oneClick=" + this.oneClick + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.countryCode).email(this.getEmail()).experienceContext(this.getExperienceContext()).level0(this.getLevel0()).oneClick(this.getOneClick());
        return builder;
    }

    public static class Builder {
        private String name;
        private String countryCode;
        private String email;
        private BLIKExperienceContext experienceContext;
        private BLIKLevel0PaymentObject level0;
        private BLIKOneClickPaymentRequest oneClick;

        public Builder() {
        }

        public Builder(String name, String countryCode) {
            this.name = name;
            this.countryCode = countryCode;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder experienceContext(BLIKExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        public Builder level0(BLIKLevel0PaymentObject level0) {
            this.level0 = level0;
            return this;
        }

        public Builder oneClick(BLIKOneClickPaymentRequest oneClick) {
            this.oneClick = oneClick;
            return this;
        }

        public BLIKPaymentRequest build() {
            return new BLIKPaymentRequest(this.name, this.countryCode, this.email, this.experienceContext, this.level0, this.oneClick);
        }
    }
}

