/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ReauthorizeRequest;

public class AuthorizationsReauthorizeInput {
    private String authorizationId;
    private String contentType;
    private String payPalRequestId;
    private String prefer;
    private ReauthorizeRequest body;

    public AuthorizationsReauthorizeInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public AuthorizationsReauthorizeInput(String authorizationId, String contentType, String payPalRequestId, String prefer, ReauthorizeRequest body) {
        this.authorizationId = authorizationId;
        this.contentType = contentType;
        this.payPalRequestId = payPalRequestId;
        this.prefer = prefer;
        this.body = body;
    }

    @JsonGetter(value="authorization_id")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @JsonSetter(value="authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayPalRequestId() {
        return this.payPalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPayPalRequestId(String payPalRequestId) {
        this.payPalRequestId = payPalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="body")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ReauthorizeRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(ReauthorizeRequest body) {
        this.body = body;
    }

    public String toString() {
        return "AuthorizationsReauthorizeInput [authorizationId=" + this.authorizationId + ", contentType=" + this.contentType + ", payPalRequestId=" + this.payPalRequestId + ", prefer=" + this.prefer + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.authorizationId, this.contentType).payPalRequestId(this.getPayPalRequestId()).prefer(this.getPrefer()).body(this.getBody());
        return builder;
    }

    public static class Builder {
        private String authorizationId;
        private String contentType = "application/json";
        private String payPalRequestId;
        private String prefer = "return=minimal";
        private ReauthorizeRequest body;

        public Builder() {
        }

        public Builder(String authorizationId, String contentType) {
            this.authorizationId = authorizationId;
            this.contentType = contentType;
        }

        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder payPalRequestId(String payPalRequestId) {
            this.payPalRequestId = payPalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder body(ReauthorizeRequest body) {
            this.body = body;
            return this;
        }

        public AuthorizationsReauthorizeInput build() {
            return new AuthorizationsReauthorizeInput(this.authorizationId, this.contentType, this.payPalRequestId, this.prefer, this.body);
        }
    }
}

