/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.Server;
import com.paypal.sdk.controllers.BaseController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.exceptions.ErrorException;
import com.paypal.sdk.http.request.HttpMethod;
import com.paypal.sdk.http.response.ApiResponse;
import com.paypal.sdk.models.AuthorizationsCaptureInput;
import com.paypal.sdk.models.AuthorizationsReauthorizeInput;
import com.paypal.sdk.models.AuthorizationsVoidInput;
import com.paypal.sdk.models.CapturedPayment;
import com.paypal.sdk.models.CapturesRefundInput;
import com.paypal.sdk.models.PaymentAuthorization;
import com.paypal.sdk.models.Refund;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class PaymentsController
extends BaseController {
    public PaymentsController(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    public ApiResponse<PaymentAuthorization> authorizationsGet(String authorizationId) throws ApiException, IOException {
        return (ApiResponse)this.prepareAuthorizationsGetRequest(authorizationId).execute();
    }

    public CompletableFuture<ApiResponse<PaymentAuthorization>> authorizationsGetAsync(String authorizationId) {
        try {
            return this.prepareAuthorizationsGetRequest(authorizationId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareAuthorizationsGetRequest(String authorizationId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}").templateParam(param -> param.key("authorization_id").value((Object)authorizationId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentAuthorization)ApiHelper.deserialize((String)response, PaymentAuthorization.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<CapturedPayment> authorizationsCapture(AuthorizationsCaptureInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareAuthorizationsCaptureRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<CapturedPayment>> authorizationsCaptureAsync(AuthorizationsCaptureInput input) {
        try {
            return this.prepareAuthorizationsCaptureRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<CapturedPayment>, ApiException> prepareAuthorizationsCaptureRequest(AuthorizationsCaptureInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}/capture").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("authorization_id").value((Object)input.getAuthorizationId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPayPalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (CapturedPayment)ApiHelper.deserialize((String)response, CapturedPayment.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"The request failed because it is not well-formed or is syntactically incorrect or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("409", ErrorCase.setReason((String)"The server has detected a conflict while processing this request.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<PaymentAuthorization> authorizationsReauthorize(AuthorizationsReauthorizeInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareAuthorizationsReauthorizeRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<PaymentAuthorization>> authorizationsReauthorizeAsync(AuthorizationsReauthorizeInput input) {
        try {
            return this.prepareAuthorizationsReauthorizeRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareAuthorizationsReauthorizeRequest(AuthorizationsReauthorizeInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}/reauthorize").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("authorization_id").value((Object)input.getAuthorizationId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPayPalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentAuthorization)ApiHelper.deserialize((String)response, PaymentAuthorization.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"The request failed because it is not well-formed or is syntactically incorrect or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it either is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<PaymentAuthorization> authorizationsVoid(AuthorizationsVoidInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareAuthorizationsVoidRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<PaymentAuthorization>> authorizationsVoidAsync(AuthorizationsVoidInput input) {
        try {
            return this.prepareAuthorizationsVoidRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareAuthorizationsVoidRequest(AuthorizationsVoidInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/authorizations/{authorization_id}/void").templateParam(param -> param.key("authorization_id").value((Object)input.getAuthorizationId()).shouldEncode(true)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPayPalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentAuthorization)ApiHelper.deserialize((String)response, PaymentAuthorization.class)).nullableResponseType(true).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"The request failed because it is not well-formed or is syntactically incorrect or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("409", ErrorCase.setReason((String)"The request failed because a previous call for the given resource is in progress.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it either is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<CapturedPayment> capturesGet(String captureId) throws ApiException, IOException {
        return (ApiResponse)this.prepareCapturesGetRequest(captureId).execute();
    }

    public CompletableFuture<ApiResponse<CapturedPayment>> capturesGetAsync(String captureId) {
        try {
            return this.prepareCapturesGetRequest(captureId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<CapturedPayment>, ApiException> prepareCapturesGetRequest(String captureId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/captures/{capture_id}").templateParam(param -> param.key("capture_id").value((Object)captureId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (CapturedPayment)ApiHelper.deserialize((String)response, CapturedPayment.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Refund> capturesRefund(CapturesRefundInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareCapturesRefundRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Refund>> capturesRefundAsync(CapturesRefundInput input) {
        try {
            return this.prepareCapturesRefundRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Refund>, ApiException> prepareCapturesRefundRequest(CapturesRefundInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/captures/{capture_id}/refund").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("capture_id").value((Object)input.getCaptureId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPayPalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPayPalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Refund)ApiHelper.deserialize((String)response, Refund.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"The request failed because it is not well-formed or is syntactically incorrect or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("409", ErrorCase.setReason((String)"The request failed because a previous call for the given resource is in progress.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The request failed because it either is semantically incorrect or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Refund> refundsGet(String refundId) throws ApiException, IOException {
        return (ApiResponse)this.prepareRefundsGetRequest(refundId).execute();
    }

    public CompletableFuture<ApiResponse<Refund>> refundsGetAsync(String refundId) {
        try {
            return this.prepareRefundsGetRequest(refundId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Refund>, ApiException> prepareRefundsGetRequest(String refundId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/refunds/{refund_id}").templateParam(param -> param.key("refund_id").value((Object)refundId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Refund)ApiHelper.deserialize((String)response, Refund.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The request failed because the caller has insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The request failed because the resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"The request failed because an internal server error occurred.", (reason, context) -> new ApiException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

