﻿## Overview

This repository contains the list of file formats (electronic documents, forms, spreadsheets, presentations) supported by ONLYOFFICE editors and describes the properties of each file format type.

The repository is used in:
* [Document Server integration example](https://github.com/ONLYOFFICE/document-server-integration)
* [ONLYOFFICE addon for Plone](https://github.com/ONLYOFFICE/onlyoffice-plone)
* [ONLYOFFICE app for Box](https://github.com/ONLYOFFICE/onlyoffice-box)
* [ONLYOFFICE app for Confluence Cloud](https://github.com/ONLYOFFICE/onlyoffice-confluence-cloud)
* [ONLYOFFICE app for Dropbox](https://github.com/ONLYOFFICE/onlyoffice-dropbox)
* [ONLYOFFICE app for Mattermost](https://github.com/ONLYOFFICE/onlyoffice-mattermost)
* [ONLYOFFICE app for Miro](https://github.com/ONLYOFFICE/onlyoffice-miro)
* [ONLYOFFICE app for Nextcloud](https://github.com/ONLYOFFICE/onlyoffice-nextcloud)
* [ONLYOFFICE app for Odoo](https://github.com/ONLYOFFICE/onlyoffice_odoo)
* [ONLYOFFICE app for ownCloud](https://github.com/ONLYOFFICE/onlyoffice-owncloud)
* [ONLYOFFICE app for Slack](https://github.com/ONLYOFFICE/onlyoffice-slack)
* [ONLYOFFICE bot for Telegram](https://github.com/ONLYOFFICE/onlyoffice-telegram)
* [ONLYOFFICE DocSpace](https://github.com/ONLYOFFICE/DocSpace)
* [ONLYOFFICE Docs Integration Java SDK](https://github.com/ONLYOFFICE/docs-integration-sdk-java)
* [ONLYOFFICE Docs Integration PHP SDK](https://github.com/ONLYOFFICE/docs-integration-sdk-php)
* [ONLYOFFICE extension for Directus](https://github.com/ONLYOFFICE/onlyoffice-directus)
* [ONLYOFFICE module for HumHub](https://github.com/ONLYOFFICE/onlyoffice-humhub)
* [ONLYOFFICE plugin for Redmine](https://github.com/ONLYOFFICE/onlyoffice-redmine)
* [ONLYOFFICE plugin for WordPress](https://github.com/ONLYOFFICE/onlyoffice-wordpress)

## Project info

ONLYOFFICE Docs (Document Server): [github.com/ONLYOFFICE/DocumentServer](https://github.com/ONLYOFFICE/DocumentServer)

Official website: [www.onlyoffice.com](https://www.onlyoffice.com/)

## Supported formats

**For viewing:**

* **WORD**: DOC, DOCM, DOCX, DOT, DOTM, DOTX, EPUB, FB2, FODT, GDOC, HML, HTM, HTML, HWP, HWPX, MD, MHT, MHTML, ODT, OTT, PAGES, RTF, STW, SXW, TXT, WPS, WPT, XML
* **CELL**: CSV, ET, ETT, FODS, GSHEET, NUMBERS, ODS, OTS, SXC, XLS, XLSM, XLSX, XLT, XLTM, XLTX
* **SLIDE**: DPS, DPT, FODP, GSLIDE, KEY, ODG, ODP, OTP, POT, POTM, POTX, PPS, PPSM, PPSX, PPT, PPTM, PPTX, SXI
* **PDF**: DJVU, DOCXF, OFORM, OXPS, PDF, XPS
* **DIAGRAM**: VSDM, VSDX, VSSM, VSSX, VSTM, VSTX

**For editing:**

* **WORD**: DOCM, DOCX, DOTM, DOTX
* **CELL**: XLSB, XLSM, XLSX, XLTM, XLTX
* **SLIDE**: POTM, POTX, PPSM, PPSX, PPTM, PPTX
* **PDF**: PDF

**For editing with possible loss of information:**

* **WORD**: EPUB, FB2, HTML, ODT, OTT, RTF, TXT
* **CELL**: CSV
* **SLIDE**: ODP, OTP

**For editing with custom filter:**

* **CELL**: CSV, ODS, OTS, XLSB, XLSM, XLSX, XLTM, XLTX

**For reviewing:**

* **WORD**: DOCM, DOCX, DOTM, DOTX, ODT, OTT, RTF

**For commenting:**

* **WORD**: DOCM, DOCX, DOTM, DOTX, ODT, OTT, RTF
* **CELL**: ODS, OTS, XLSB, XLSM, XLSX, XLTM, XLTX
* **SLIDE**: ODP, OTP, POTM, POTX, PPSM, PPSX, PPTM, PPTX
* **PDF**: PDF

**For filling:**

* **PDF**: PDF

**For encrypting:**

* **WORD**: DOCM, DOCX, DOTM, DOTX, ODT, OTT
* **CELL**: ODS, OTS, XLSB, XLSM, XLSX, XLTM, XLTX
* **SLIDE**: ODP, OTP, POTM, POTX, PPSM, PPSX, PPTM, PPTX
* **PDF**: PDF

**For converting to Office Open XML formats:**

* **WORD**: DOC, DOCM, DOCX, DOT, DOTM, DOTX, EPUB, FB2, FODT, HML, HTM, HTML, HWP, HWPX, MD, MHT, MHTML, ODT, OTT, PAGES, RTF, STW, SXW, TXT, WPS, WPT, XML
* **CELL**: CSV, ET, ETT, FODS, NUMBERS, ODS, OTS, SXC, XLS, XLSB, XLSM, XLSX, XLT, XLTM, XLTX
* **SLIDE**: DPS, DPT, FODP, KEY, ODG, ODP, OTP, POT, POTM, POTX, PPS, PPSM, PPSX, PPT, PPTM, PPTX, SXI
* **PDF**: DOCXF, OXPS, PDF, XPS
